/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.resp;

import com.github.fmjsjx.libnetty.resp.DefaultArrayMessage;
import com.github.fmjsjx.libnetty.resp.RespArrayMessage;
import com.github.fmjsjx.libnetty.resp.RespBulkStringMessage;
import com.github.fmjsjx.libnetty.resp.RespMessage;
import com.github.fmjsjx.libnetty.resp.RespMessages;
import com.github.fmjsjx.libnetty.resp.RespSimpleStringMessage;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;

class TestClientHandler
extends SimpleChannelInboundHandler<RespMessage> {
    private int count = 0;

    TestClientHandler() {
    }

    protected void channelRead0(ChannelHandlerContext ctx, RespMessage msg) throws Exception {
        System.out.println("-- RESP message received --");
        System.out.println(msg);
        if (msg instanceof RespBulkStringMessage || msg instanceof RespArrayMessage) {
            switch (this.count++) {
                case 0: {
                    ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "SMEMBERS", "any key for test"));
                    break;
                }
                case 1: {
                    ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "SMEMBERS", "3"));
                    break;
                }
                case 2: {
                    ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "SMEMBERS", "12"));
                    break;
                }
                case 3: {
                    ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "PING", "PING may same with ECHO"));
                    break;
                }
                case 4: {
                    ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "GET", "https://www.baidu.com/"));
                    break;
                }
                case 5: {
                    ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "GET", "https://www.sogou.com/"));
                    break;
                }
                default: {
                    ctx.writeAndFlush((Object)TestClientHandler.command(ctx.alloc(), "QUIT"));
                    break;
                }
            }
        } else if (msg instanceof RespSimpleStringMessage && RespMessages.ok().value().equals(((RespSimpleStringMessage)msg).value())) {
            System.out.println("is OK");
            ctx.close();
        }
    }

    private static RespMessage command(ByteBufAllocator alloc, String ... commands) {
        return DefaultArrayMessage.bulkStringArrayUtf8((ByteBufAllocator)alloc, (CharSequence[])commands);
    }
}

