/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.http.server;

import com.github.fmjsjx.libnetty.example.http.server.TestHandler;
import com.github.fmjsjx.libnetty.handler.ssl.SslContextProvider;
import com.github.fmjsjx.libnetty.handler.ssl.SslContextProviders;
import com.github.fmjsjx.libnetty.http.server.DefaultHttpServer;
import com.github.fmjsjx.libnetty.http.server.HttpServerHandler;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import java.io.File;

public class TestWatchingSslServer {
    private static final String sslCertPath = System.getProperty("ssl.certFile", "src/main/resources/ssl/localhost.crt");
    private static final String sslKeyFile = System.getProperty("ssl.keyFile", "src/main/resources/ssl/localhost.key");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File keyCertChainFile = new File(sslCertPath);
        File keyFile = new File(sslKeyFile);
        CorsConfig corsConfig = CorsConfigBuilder.forAnyOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE}).allowedRequestHeaders(new String[]{"*"}).allowNullOrigin().build();
        try (SslContextProvider sslContextProvider = SslContextProviders.watchingForServer((File)keyCertChainFile, (File)keyFile);){
            DefaultHttpServer server = new DefaultHttpServer("test", sslContextProvider, 8443).corsConfig(corsConfig).ioThreads(1).maxContentLength(0xA00000).soBackLog(1024).tcpNoDelay();
            server.handler((HttpServerHandler)new TestHandler());
            try {
                server.startup();
                System.in.read();
            }
            catch (Exception e) {
                System.err.println("Unexpected error occurs when startup " + server);
                e.printStackTrace();
            }
            finally {
                if (server.isRunning()) {
                    server.shutdown();
                }
            }
        }
    }
}

