/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.resp;

import com.github.fmjsjx.libnetty.http.client.HttpContentHandlers;
import com.github.fmjsjx.libnetty.http.client.SimpleHttpClient;
import com.github.fmjsjx.libnetty.resp.DefaultBulkStringMessage;
import com.github.fmjsjx.libnetty.resp.DefaultErrorMessage;
import com.github.fmjsjx.libnetty.resp.RedisRequest;
import com.github.fmjsjx.libnetty.resp.RespBulkStringMessage;
import com.github.fmjsjx.libnetty.resp.RespMessages;
import com.github.fmjsjx.libnetty.resp.util.IgnoredCaseAsciiKeyMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;

class TestServerHandler
extends SimpleChannelInboundHandler<RedisRequest> {
    private static final ChannelFutureListener READ_NEXT = f -> f.channel().read();
    private final IgnoredCaseAsciiKeyMap<BiConsumer<ChannelHandlerContext, RedisRequest>> commandProcedures = new IgnoredCaseAsciiKeyMap();

    TestServerHandler() {
        this.commandProcedures.put("GET", this::get);
        this.commandProcedures.put("ECHO", this::echo);
        this.commandProcedures.put("PING", this::ping);
        this.commandProcedures.put("SELECT", this::justOk);
        this.commandProcedures.put("QUIT", this::quit);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        System.err.println(ctx.channel() + " connected");
        ctx.read();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        System.err.println(ctx.channel() + " disconnected");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, RedisRequest msg) throws Exception {
        System.out.println("-- message received --");
        System.out.println(msg);
        BiConsumer procedure = (BiConsumer)this.commandProcedures.get(msg.command().content());
        if (procedure == null) {
            String cmd = msg.command().toText();
            ctx.writeAndFlush((Object)DefaultErrorMessage.createErrAscii((ByteBufAllocator)ctx.alloc(), (CharSequence)("unknown command `" + cmd + "`"))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            procedure.accept(ctx, msg);
        }
    }

    private void echo(ChannelHandlerContext ctx, RedisRequest msg) {
        if (msg.size() != 2) {
            ctx.writeAndFlush((Object)RespMessages.wrongNumberOfArgumentsForCommand((String)"echo")).addListener((GenericFutureListener)READ_NEXT);
        } else {
            RespBulkStringMessage message = msg.argument(1);
            ctx.writeAndFlush((Object)message.retainedDuplicate()).addListener((GenericFutureListener)READ_NEXT);
        }
    }

    private void ping(ChannelHandlerContext ctx, RedisRequest msg) {
        int size = msg.size();
        if (msg.size() == 1) {
            ctx.writeAndFlush((Object)RespMessages.pong()).addListener((GenericFutureListener)READ_NEXT);
        } else if (size == 2) {
            ctx.writeAndFlush((Object)msg.argument(1).retainedDuplicate()).addListener((GenericFutureListener)READ_NEXT);
        } else {
            ctx.writeAndFlush((Object)RespMessages.wrongNumberOfArgumentsForCommand((String)"ping")).addListener((GenericFutureListener)READ_NEXT);
        }
    }

    private void get(ChannelHandlerContext ctx, RedisRequest msg) {
        Channel channel = ctx.channel();
        String path = msg.argument(1).textValue(CharsetUtil.UTF_8);
        try (SimpleHttpClient client = SimpleHttpClient.builder().build((EventLoopGroup)channel.eventLoop(), channel.getClass());){
            ((CompletableFuture)client.request(URI.create(path)).get().sendAsync(HttpContentHandlers.ofByteArray()).thenAccept(r -> {
                if (r.statusCode() >= 400) {
                    channel.writeAndFlush((Object)DefaultErrorMessage.createErrUtf8((ByteBufAllocator)channel.alloc(), (CharSequence)r.status().toString())).addListener((GenericFutureListener)READ_NEXT);
                } else {
                    ByteBuf content = channel.alloc().buffer(((byte[])r.content()).length).writeBytes((byte[])r.content());
                    channel.writeAndFlush((Object)new DefaultBulkStringMessage(content)).addListener((GenericFutureListener)READ_NEXT);
                }
            })).whenComplete((v, e) -> {
                if (e != null) {
                    if (e instanceof CompletionException) {
                        e = e.getCause();
                    }
                    channel.writeAndFlush((Object)DefaultErrorMessage.createErrUtf8((ByteBufAllocator)channel.alloc(), (CharSequence)e.toString())).addListener((GenericFutureListener)READ_NEXT);
                }
            });
        }
    }

    private void justOk(ChannelHandlerContext ctx, RedisRequest msg) {
        ctx.writeAndFlush((Object)RespMessages.ok()).addListener((GenericFutureListener)READ_NEXT);
    }

    private void quit(ChannelHandlerContext ctx, RedisRequest msg) {
        ctx.writeAndFlush((Object)RespMessages.ok()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

