/*
 * Decompiled with CFR 0.152.
 */
package flowctrl.integration.slack.webhook;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import flowctrl.integration.slack.RestUtils;
import flowctrl.integration.slack.exception.SlackArgumentException;
import flowctrl.integration.slack.exception.SlackException;
import flowctrl.integration.slack.type.Payload;
import java.util.HashMap;
import org.apache.http.impl.client.CloseableHttpClient;

public class SlackWebhookClient {
    private String webhookUrl;
    private ObjectMapper mapper;
    private CloseableHttpClient httpClient;

    public SlackWebhookClient(String webhookUrl) {
        this(webhookUrl, null);
    }

    public SlackWebhookClient(String webhookUrl, ObjectMapper mapper) {
        this(webhookUrl, mapper, 5000);
    }

    public SlackWebhookClient(String webhookUrl, ObjectMapper mapper, int timeout) {
        if (webhookUrl == null) {
            throw new SlackArgumentException("Missing WebHook URL Configuration @ SlackApi");
        }
        if (!webhookUrl.startsWith("https://hooks.slack.com/services/")) {
            throw new SlackArgumentException("Invalid Service URL. WebHook URL Format: https://hooks.slack.com/services/{id_1}/{id_2}/{token}");
        }
        this.webhookUrl = webhookUrl;
        this.mapper = mapper != null ? mapper : new ObjectMapper();
        this.httpClient = RestUtils.createHttpClient(timeout);
    }

    public void shutdown() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String post(Payload payload) {
        if (payload != null) {
            String message = null;
            try {
                message = this.mapper.writeValueAsString((Object)payload);
            }
            catch (JsonProcessingException e) {
                throw new SlackException(e);
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("payload", message);
            return RestUtils.execute(this.httpClient, this.webhookUrl, RestUtils.createUrlEncodedFormEntity(parameters));
        }
        return null;
    }
}

