/*
 * Decompiled with CFR 0.152.
 */
package flowctrl.integration.slack.webapi.method.chats;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import flowctrl.integration.slack.exception.SlackException;
import flowctrl.integration.slack.type.Attachment;
import flowctrl.integration.slack.validation.Problem;
import flowctrl.integration.slack.validation.ValidationError;
import flowctrl.integration.slack.webapi.method.AbstractMethod;
import java.util.List;
import java.util.Map;

public class ChatUpdateMethod
extends AbstractMethod {
    protected ObjectMapper mapper;
    protected String channel;
    protected String ts;
    protected String text;
    protected List<Attachment> attachments;
    protected boolean link_names;

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ChatUpdateMethod(String channel, String ts, String text) {
        this.channel = channel;
        this.ts = ts;
        this.text = text;
    }

    public String getTs() {
        return this.ts;
    }

    public void setTs(String ts) {
        this.ts = ts;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public boolean isLink_names() {
        return this.link_names;
    }

    public void setLink_names(boolean link_names) {
        this.link_names = link_names;
    }

    @Override
    public String getMethodName() {
        return "chat.update";
    }

    @Override
    public void validate(List<ValidationError> errors) {
        if (this.channel == null) {
            this.addError(errors, "channel", Problem.REQUIRED);
        }
        if (this.ts == null) {
            this.addError(errors, "ts", Problem.REQUIRED);
        }
        if (this.text == null) {
            this.addError(errors, "text", Problem.REQUIRED);
        }
    }

    @Override
    protected void createParameters(Map<String, String> parameters) {
        parameters.put("ts", this.ts);
        parameters.put("channel", this.channel);
        parameters.put("text", this.text);
        if (this.attachments != null && !this.attachments.isEmpty()) {
            try {
                parameters.put("attachments", this.mapper.writeValueAsString(this.attachments));
            }
            catch (JsonProcessingException e) {
                throw new SlackException(e);
            }
        }
        if (this.link_names) {
            parameters.put("link_names", "1");
            parameters.put("parse", "full");
        } else {
            parameters.put("parse", "none");
        }
    }
}

