/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker;

import androidx.annotation.NonNull;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateHelper {
    private TimeZone timeZone = TimeZone.getDefault();

    public DateHelper() {
        this.timeZone = TimeZone.getDefault();
    }

    public DateHelper(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setTimeZone(TimeZone timeZoneValue) {
        this.timeZone = timeZoneValue;
    }

    @NonNull
    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            return TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public Calendar getCalendarOfDate(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        return calendar;
    }

    public int getHour(Date date) {
        return this.getCalendarOfDate(date).get(10);
    }

    public int getHourOfDay(Date date) {
        return this.getCalendarOfDate(date).get(10);
    }

    public int getHour(Date date, boolean isAmPm) {
        if (isAmPm) {
            return this.getHourOfDay(date);
        }
        return this.getHour(date);
    }

    public int getMinuteOf(Date date) {
        return this.getCalendarOfDate(date).get(12);
    }

    public Date today() {
        Calendar now = Calendar.getInstance(this.getTimeZone());
        return now.getTime();
    }

    public int getMonth(Date date) {
        return this.getCalendarOfDate(date).get(2);
    }

    public int getDay(Date date) {
        return this.getCalendarOfDate(date).get(5);
    }

    public static int compareDateIgnoreTime(Date first, Date second) {
        Date firstZeroTime = DateHelper.getZeroTimeDateWithoutTimeZone(first);
        Date secondZeroTime = DateHelper.getZeroTimeDateWithoutTimeZone(second);
        return firstZeroTime.compareTo(secondZeroTime);
    }

    private static Date getZeroTimeDateWithoutTimeZone(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

