/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.util.ArrayList;

public class WheelAmPmPicker
extends WheelPicker {
    public static final int INDEX_AM = 0;
    public static final int INDEX_PM = 1;
    private WheelPicker.Adapter adapter;
    private int lastScrollPosition;
    private OnAmPmSelectedListener onAmPmSelectedListener;

    public WheelAmPmPicker(Context context) {
        this(context, null);
    }

    public WheelAmPmPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAdapter();
    }

    private void initAdapter() {
        ArrayList<String> values = new ArrayList<String>();
        Resources resources = this.getResources();
        values.add(resources.getString(R.string.picker_am));
        values.add(resources.getString(R.string.picker_pm));
        this.adapter = new WheelPicker.Adapter(values);
        this.setAdapter(this.adapter);
    }

    public void setOnAmPmSelectedListener(OnAmPmSelectedListener onAmPmSelectedListener) {
        this.onAmPmSelectedListener = onAmPmSelectedListener;
    }

    @Override
    protected void onItemSelected(int position, Object item) {
        if (this.onAmPmSelectedListener != null) {
            if (position == 0) {
                this.onAmPmSelectedListener.onAmSelected(this);
            } else {
                this.onAmPmSelectedListener.onPmSelected(this);
            }
        }
    }

    @Override
    protected void onItemCurrentScroll(int position, Object item) {
        if (this.lastScrollPosition != position) {
            this.lastScrollPosition = position;
        }
    }

    @Override
    protected String getFormattedValue(Object value) {
        return String.valueOf(value);
    }

    @Override
    public int getDefaultItemPosition() {
        return 0;
    }

    public boolean isAm() {
        return this.getCurrentItemPosition() == 0;
    }

    public boolean isPm() {
        return this.getCurrentItemPosition() == 1;
    }

    public void setAmSelected() {
        this.setSelectedItemPosition(0);
    }

    public void setPmSelected() {
        this.setSelectedItemPosition(1);
    }

    public static interface OnAmPmSelectedListener {
        public void onAmSelected(WheelAmPmPicker var1);

        public void onPmSelected(WheelAmPmPicker var1);
    }
}

