/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class WheelHourPicker
extends WheelPicker<String> {
    private int minHour;
    private int maxHour;
    private int hoursStep;
    protected boolean isAmPm;
    private FinishedLoopListener finishedLoopListener;
    private OnHourChangedListener hourChangedListener;

    public WheelHourPicker(Context context) {
        super(context);
    }

    public WheelHourPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
        this.isAmPm = false;
        this.minHour = 0;
        this.maxHour = 23;
        this.hoursStep = 1;
    }

    @Override
    protected String initDefault() {
        return String.valueOf(this.dateHelper.getHour(this.dateHelper.today(), this.isAmPm));
    }

    @Override
    protected List<String> generateAdapterValues(boolean showOnlyFutureDates) {
        ArrayList<String> hours = new ArrayList<String>();
        if (this.isAmPm) {
            hours.add(this.getFormattedValue(12));
            for (int hour = this.hoursStep; hour < this.maxHour; hour += this.hoursStep) {
                hours.add(this.getFormattedValue(hour));
            }
        } else {
            for (int hour = this.minHour; hour <= this.maxHour; hour += this.hoursStep) {
                hours.add(this.getFormattedValue(hour));
            }
        }
        return hours;
    }

    @Override
    public int findIndexOfDate(@NonNull Date date) {
        int hours;
        if (this.isAmPm && (hours = date.getHours()) >= 12) {
            Date copy = new Date(date.getTime());
            copy.setHours(hours % 12);
            return super.findIndexOfDate(copy);
        }
        return super.findIndexOfDate(date);
    }

    @Override
    protected String getFormattedValue(Object value) {
        Object valueItem = value;
        if (value instanceof Date) {
            Calendar instance = Calendar.getInstance();
            instance.setTimeZone(this.dateHelper.getTimeZone());
            instance.setTime((Date)value);
            valueItem = instance.get(11);
        }
        return String.format(this.getCurrentLocale(), "%1$02d", valueItem);
    }

    @Override
    public void setDefault(String defaultValue) {
        try {
            int hour = Integer.parseInt(defaultValue);
            if (this.isAmPm && hour >= 12) {
                hour -= 12;
            }
            super.setDefault(this.getFormattedValue(hour));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setIsAmPm(boolean isAmPm) {
        this.isAmPm = isAmPm;
        if (isAmPm) {
            this.setMaxHour(12);
        } else {
            this.setMaxHour(23);
        }
        this.updateAdapter();
    }

    public void setMaxHour(int maxHour) {
        if (maxHour >= 0 && maxHour <= 23) {
            this.maxHour = maxHour;
        }
        this.notifyDatasetChanged();
    }

    public void setMinHour(int minHour) {
        if (minHour >= 0 && minHour <= 23) {
            this.minHour = minHour;
        }
        this.notifyDatasetChanged();
    }

    public void setStepSizeHours(int hoursStep) {
        if (hoursStep >= 0 && hoursStep <= 23) {
            this.hoursStep = hoursStep;
        }
        this.notifyDatasetChanged();
    }

    private int convertItemToHour(Object item) {
        Integer hour = Integer.valueOf(String.valueOf(item));
        if (!this.isAmPm) {
            return hour;
        }
        if (hour == 12) {
            hour = 0;
        }
        return hour;
    }

    public int getCurrentHour() {
        return this.convertItemToHour(this.adapter.getItem(this.getCurrentItemPosition()));
    }

    @Override
    protected void onItemSelected(int position, String item) {
        super.onItemSelected(position, item);
        if (this.hourChangedListener != null) {
            this.hourChangedListener.onHourChanged(this, this.convertItemToHour(item));
        }
    }

    public WheelHourPicker setOnFinishedLoopListener(FinishedLoopListener finishedLoopListener) {
        this.finishedLoopListener = finishedLoopListener;
        return this;
    }

    public WheelHourPicker setHourChangedListener(OnHourChangedListener hourChangedListener) {
        this.hourChangedListener = hourChangedListener;
        return this;
    }

    @Override
    protected void onFinishedLoop() {
        super.onFinishedLoop();
        if (this.finishedLoopListener != null) {
            this.finishedLoopListener.onFinishedLoop(this);
        }
    }

    public static interface OnHourChangedListener {
        public void onHourChanged(WheelHourPicker var1, int var2);
    }

    public static interface FinishedLoopListener {
        public void onFinishedLoop(WheelHourPicker var1);
    }
}

