/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.dialog;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.singledateandtimepicker.DateHelper;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.SingleDateAndTimePicker;
import com.github.florent37.singledateandtimepicker.dialog.BaseDialog;
import com.github.florent37.singledateandtimepicker.dialog.BottomSheetHelper;
import com.github.florent37.singledateandtimepicker.widget.DateWithLabel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DoubleDateAndTimePickerDialog
extends BaseDialog {
    private Listener listener;
    private BottomSheetHelper bottomSheetHelper;
    private TextView buttonTab0;
    private TextView buttonTab1;
    private SingleDateAndTimePicker pickerTab0;
    private SingleDateAndTimePicker pickerTab1;
    private final DateHelper dateHelper = new DateHelper();
    private View tab0;
    private View tab1;
    @Nullable
    private String tab0Text;
    @Nullable
    private String tab1Text;
    @Nullable
    private String title;
    @Nullable
    private Integer titleTextSize;
    @Nullable
    private Integer bottomSheetHeight;
    @Nullable
    private String todayText;
    @Nullable
    private String buttonOkText;
    @Nullable
    private Date tab0Date;
    @Nullable
    private Date tab1Date;
    private boolean secondDateAfterFirst;
    private boolean tab0Days;
    private boolean tab0Hours;
    private boolean tab0Minutes;
    private boolean tab1Days;
    private boolean tab1Hours;
    private boolean tab1Minutes;

    private DoubleDateAndTimePickerDialog(Context context) {
        this(context, false);
    }

    private DoubleDateAndTimePickerDialog(Context context, boolean bottomSheet) {
        int layout2 = bottomSheet ? R.layout.bottom_sheet_double_picker_bottom_sheet : R.layout.bottom_sheet_double_picker;
        this.bottomSheetHelper = new BottomSheetHelper(context, layout2);
        this.bottomSheetHelper.setListener(new BottomSheetHelper.Listener(){

            @Override
            public void onOpen() {
            }

            @Override
            public void onLoaded(View view) {
                DoubleDateAndTimePickerDialog.this.init(view);
            }

            @Override
            public void onClose() {
                DoubleDateAndTimePickerDialog.this.onClose();
            }
        });
    }

    private void init(View view) {
        Calendar calendar;
        ViewGroup.LayoutParams params;
        this.buttonTab0 = (TextView)view.findViewById(R.id.buttonTab0);
        this.buttonTab1 = (TextView)view.findViewById(R.id.buttonTab1);
        this.pickerTab0 = (SingleDateAndTimePicker)view.findViewById(R.id.picker_tab_0);
        this.pickerTab1 = (SingleDateAndTimePicker)view.findViewById(R.id.picker_tab_1);
        this.tab0 = view.findViewById(R.id.tab0);
        this.tab1 = view.findViewById(R.id.tab1);
        if (this.pickerTab0 != null && this.bottomSheetHeight != null) {
            params = this.pickerTab0.getLayoutParams();
            params.height = this.bottomSheetHeight;
            this.pickerTab0.setLayoutParams(params);
        }
        if (this.pickerTab1 != null && this.bottomSheetHeight != null) {
            params = this.pickerTab1.getLayoutParams();
            params.height = this.bottomSheetHeight;
            this.pickerTab1.setLayoutParams(params);
        }
        View titleLayout = view.findViewById(R.id.sheetTitleLayout);
        TextView titleTextView = (TextView)view.findViewById(R.id.sheetTitle);
        if (this.title != null) {
            if (titleTextView != null) {
                titleTextView.setText((CharSequence)this.title);
                if (this.titleTextColor != null) {
                    titleTextView.setTextColor(this.titleTextColor.intValue());
                }
                if (this.titleTextSize != null) {
                    titleTextView.setTextSize((float)this.titleTextSize.intValue());
                }
            }
            if (this.mainColor != null && titleLayout != null) {
                titleLayout.setBackgroundColor(this.mainColor.intValue());
            }
        } else {
            titleLayout.setVisibility(8);
        }
        this.pickerTab0.setTodayText(new DateWithLabel(this.todayText, new Date()));
        this.pickerTab1.setTodayText(new DateWithLabel(this.todayText, new Date()));
        View sheetContentLayout = view.findViewById(R.id.sheetContentLayout);
        if (sheetContentLayout != null) {
            sheetContentLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
            if (this.backgroundColor != null) {
                sheetContentLayout.setBackgroundColor(this.backgroundColor.intValue());
            }
        }
        this.tab1.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                DoubleDateAndTimePickerDialog.this.tab1.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                DoubleDateAndTimePickerDialog.this.tab1.setTranslationX((float)DoubleDateAndTimePickerDialog.this.tab1.getWidth());
                return false;
            }
        });
        this.buttonTab0.setSelected(true);
        if (this.tab0Text != null) {
            this.buttonTab0.setText((CharSequence)this.tab0Text);
        }
        this.buttonTab0.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DoubleDateAndTimePickerDialog.this.displayTab0();
            }
        });
        if (this.tab1Text != null) {
            this.buttonTab1.setText((CharSequence)this.tab1Text);
        }
        this.buttonTab1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DoubleDateAndTimePickerDialog.this.displayTab1();
            }
        });
        this.buttonTab0.setBackgroundDrawable((Drawable)this.getTabsListDrawable());
        this.buttonTab1.setBackgroundDrawable((Drawable)this.getTabsListDrawable());
        TextView buttonOk = (TextView)view.findViewById(R.id.buttonOk);
        if (buttonOk != null) {
            if (this.buttonOkText != null) {
                buttonOk.setText((CharSequence)this.buttonOkText);
            }
            if (this.mainColor != null) {
                buttonOk.setTextColor(this.mainColor.intValue());
            }
            if (this.titleTextSize != null) {
                buttonOk.setTextSize((float)this.titleTextSize.intValue());
            }
        }
        buttonOk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (DoubleDateAndTimePickerDialog.this.isTab0Visible()) {
                    DoubleDateAndTimePickerDialog.this.displayTab1();
                } else {
                    DoubleDateAndTimePickerDialog.this.okClicked = true;
                    DoubleDateAndTimePickerDialog.this.close();
                }
            }
        });
        if (this.curved) {
            this.pickerTab0.setCurved(true);
            this.pickerTab1.setCurved(true);
            this.pickerTab0.setVisibleItemCount(7);
            this.pickerTab1.setVisibleItemCount(7);
        } else {
            this.pickerTab0.setCurved(false);
            this.pickerTab1.setCurved(false);
            this.pickerTab0.setVisibleItemCount(5);
            this.pickerTab1.setVisibleItemCount(5);
        }
        this.pickerTab0.setDisplayDays(this.tab0Days);
        this.pickerTab0.setDisplayHours(this.tab0Hours);
        this.pickerTab0.setDisplayMinutes(this.tab0Minutes);
        this.pickerTab1.setDisplayDays(this.tab1Days);
        this.pickerTab1.setDisplayHours(this.tab1Hours);
        this.pickerTab1.setDisplayMinutes(this.tab1Minutes);
        this.pickerTab0.setMustBeOnFuture(this.mustBeOnFuture);
        this.pickerTab1.setMustBeOnFuture(this.mustBeOnFuture);
        this.pickerTab0.setStepSizeMinutes(this.minutesStep);
        this.pickerTab1.setStepSizeMinutes(this.minutesStep);
        if (this.mainColor != null) {
            this.pickerTab0.setSelectedTextColor(this.mainColor);
            this.pickerTab1.setSelectedTextColor(this.mainColor);
        }
        if (this.minDate != null) {
            this.pickerTab0.setMinDate(this.minDate);
            this.pickerTab1.setMinDate(this.minDate);
        }
        if (this.maxDate != null) {
            this.pickerTab0.setMaxDate(this.maxDate);
            this.pickerTab1.setMaxDate(this.maxDate);
        }
        if (this.defaultDate != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(this.defaultDate);
            this.pickerTab0.selectDate(calendar);
            this.pickerTab1.selectDate(calendar);
        }
        if (this.tab0Date != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(this.tab0Date);
            this.pickerTab0.selectDate(calendar);
        }
        if (this.tab1Date != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(this.tab1Date);
            this.pickerTab1.selectDate(calendar);
        }
        if (this.dayFormatter != null) {
            this.pickerTab0.setDayFormatter(this.dayFormatter);
            this.pickerTab1.setDayFormatter(this.dayFormatter);
        }
        if (this.customLocale != null) {
            this.pickerTab0.setCustomLocale(this.customLocale);
            this.pickerTab1.setCustomLocale(this.customLocale);
        }
        if (this.secondDateAfterFirst) {
            this.pickerTab0.addOnDateChangedListener(new SingleDateAndTimePicker.OnDateChangedListener(){

                @Override
                public void onDateChanged(String displayed, Date date) {
                    DoubleDateAndTimePickerDialog.this.pickerTab1.setMinDate(date);
                    DoubleDateAndTimePickerDialog.this.pickerTab1.checkPickersMinMax();
                }
            });
        }
    }

    @NonNull
    private StateListDrawable getTabsListDrawable() {
        StateListDrawable colorState0 = new StateListDrawable();
        colorState0.addState(new int[]{0x10100A1}, (Drawable)new ColorDrawable(this.mainColor.intValue()));
        colorState0.addState(new int[]{-16842913}, (Drawable)new ColorDrawable(this.backgroundColor.intValue()));
        return colorState0;
    }

    public DoubleDateAndTimePickerDialog setTab0Text(String tab0Text) {
        this.tab0Text = tab0Text;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTab1Text(String tab1Text) {
        this.tab1Text = tab1Text;
        return this;
    }

    public DoubleDateAndTimePickerDialog setButtonOkText(@Nullable String buttonOkText) {
        this.buttonOkText = buttonOkText;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTitleTextSize(@Nullable Integer titleTextSize) {
        this.titleTextSize = titleTextSize;
        return this;
    }

    public DoubleDateAndTimePickerDialog setBottomSheetHeight(@Nullable Integer bottomSheetHeight) {
        this.bottomSheetHeight = bottomSheetHeight;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTodayText(@Nullable String todayText) {
        this.todayText = todayText;
        return this;
    }

    public DoubleDateAndTimePickerDialog setListener(Listener listener) {
        this.listener = listener;
        return this;
    }

    public DoubleDateAndTimePickerDialog setCurved(boolean curved) {
        this.curved = curved;
        return this;
    }

    public DoubleDateAndTimePickerDialog setMinutesStep(int minutesStep) {
        this.minutesStep = minutesStep;
        return this;
    }

    public DoubleDateAndTimePickerDialog setMustBeOnFuture(boolean mustBeOnFuture) {
        this.mustBeOnFuture = mustBeOnFuture;
        return this;
    }

    public DoubleDateAndTimePickerDialog setMinDateRange(Date minDate) {
        this.minDate = minDate;
        return this;
    }

    public DoubleDateAndTimePickerDialog setMaxDateRange(Date maxDate) {
        this.maxDate = maxDate;
        return this;
    }

    public DoubleDateAndTimePickerDialog setDefaultDate(Date defaultDate) {
        this.defaultDate = defaultDate;
        return this;
    }

    public DoubleDateAndTimePickerDialog setDayFormatter(SimpleDateFormat dayFormatter) {
        this.dayFormatter = dayFormatter;
        return this;
    }

    public DoubleDateAndTimePickerDialog setCustomLocale(Locale locale) {
        this.customLocale = locale;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTab0Date(Date tab0Date) {
        this.tab0Date = tab0Date;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTab1Date(Date tab1Date) {
        this.tab1Date = tab1Date;
        return this;
    }

    public DoubleDateAndTimePickerDialog setSecondDateAfterFirst(boolean secondDateAfterFirst) {
        this.secondDateAfterFirst = secondDateAfterFirst;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTab0DisplayDays(boolean tab0Days) {
        this.tab0Days = tab0Days;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTab0DisplayHours(boolean tab0Hours) {
        this.tab0Hours = tab0Hours;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTab0DisplayMinutes(boolean tab0Minutes) {
        this.tab0Minutes = tab0Minutes;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTab1DisplayDays(boolean tab1Days) {
        this.tab1Days = tab1Days;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTab1DisplayHours(boolean tab1Hours) {
        this.tab1Hours = tab1Hours;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTab1DisplayMinutes(boolean tab1Minutes) {
        this.tab1Minutes = tab1Minutes;
        return this;
    }

    private DoubleDateAndTimePickerDialog setTimeZone(TimeZone timeZone) {
        this.dateHelper.setTimeZone(timeZone);
        this.pickerTab0.setTimeZone(timeZone);
        this.pickerTab1.setTimeZone(timeZone);
        return this;
    }

    @Override
    public void display() {
        super.display();
        this.bottomSheetHelper.display();
    }

    @Override
    public void dismiss() {
        super.dismiss();
        this.bottomSheetHelper.dismiss();
    }

    @Override
    public void close() {
        super.close();
        this.bottomSheetHelper.hide();
    }

    @Override
    protected void onClose() {
        super.onClose();
        if (this.listener != null && this.okClicked) {
            this.listener.onDateSelected(Arrays.asList(this.pickerTab0.getDate(), this.pickerTab1.getDate()));
        }
    }

    private void displayTab0() {
        if (!this.isTab0Visible()) {
            this.buttonTab0.setSelected(true);
            this.buttonTab1.setSelected(false);
            this.tab0.animate().translationX(0.0f);
            this.tab1.animate().translationX((float)this.tab1.getWidth());
        }
    }

    private void displayTab1() {
        if (this.isTab0Visible()) {
            this.buttonTab0.setSelected(false);
            this.buttonTab1.setSelected(true);
            this.tab0.animate().translationX((float)(-this.tab0.getWidth()));
            this.tab1.animate().translationX(0.0f);
        }
    }

    private boolean isTab0Visible() {
        return this.tab0.getTranslationX() == 0.0f;
    }

    public static class Builder {
        private final Context context;
        @Nullable
        private Listener listener;
        private boolean bottomSheet;
        private DoubleDateAndTimePickerDialog dialog;
        @Nullable
        private String tab0Text;
        @Nullable
        private String tab1Text;
        @Nullable
        private String title;
        @Nullable
        private Integer titleTextSize;
        @Nullable
        private Integer bottomSheetHeight;
        @Nullable
        private String buttonOkText;
        @Nullable
        private String todayText;
        private boolean curved;
        private boolean secondDateAfterFirst;
        private boolean mustBeOnFuture;
        private int minutesStep = 5;
        private SimpleDateFormat dayFormatter;
        private Locale customLocale;
        @ColorInt
        @Nullable
        private Integer backgroundColor = null;
        @ColorInt
        @Nullable
        private Integer mainColor = null;
        @ColorInt
        @Nullable
        private Integer titleTextColor = null;
        @Nullable
        private Date minDate;
        @Nullable
        private Date maxDate;
        @Nullable
        private Date defaultDate;
        @Nullable
        private Date tab0Date;
        @Nullable
        private Date tab1Date;
        private boolean tab0Days = true;
        private boolean tab0Hours = true;
        private boolean tab0Minutes = true;
        private boolean tab1Days = true;
        private boolean tab1Hours = true;
        private boolean tab1Minutes = true;
        private TimeZone timeZone;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public Builder titleTextSize(@Nullable Integer titleTextSize) {
            this.titleTextSize = titleTextSize;
            return this;
        }

        public Builder bottomSheetHeight(@Nullable Integer bottomSheetHeight) {
            this.bottomSheetHeight = bottomSheetHeight;
            return this;
        }

        public Builder todayText(@Nullable String todayText) {
            this.todayText = todayText;
            return this;
        }

        public Builder bottomSheet() {
            this.bottomSheet = true;
            return this;
        }

        public Builder curved() {
            this.curved = true;
            return this;
        }

        public Builder mustBeOnFuture() {
            this.mustBeOnFuture = true;
            return this;
        }

        public Builder dayFormatter(SimpleDateFormat dayFormatter) {
            this.dayFormatter = dayFormatter;
            return this;
        }

        public Builder customLocale(Locale locale) {
            this.customLocale = locale;
            return this;
        }

        public Builder minutesStep(int minutesStep) {
            this.minutesStep = minutesStep;
            return this;
        }

        public Builder titleTextColor(@NonNull @ColorInt int titleTextColor) {
            this.titleTextColor = titleTextColor;
            return this;
        }

        public Builder backgroundColor(@NonNull @ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder mainColor(@NonNull @ColorInt int mainColor) {
            this.mainColor = mainColor;
            return this;
        }

        public Builder minDateRange(Date minDate) {
            this.minDate = minDate;
            return this;
        }

        public Builder maxDateRange(Date maxDate) {
            this.maxDate = maxDate;
            return this;
        }

        public Builder defaultDate(Date defaultDate) {
            this.defaultDate = defaultDate;
            return this;
        }

        public Builder tab0Date(Date tab0Date) {
            this.tab0Date = tab0Date;
            return this;
        }

        public Builder tab1Date(Date tab1Date) {
            this.tab1Date = tab1Date;
            return this;
        }

        public Builder listener(@Nullable Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder tab1Text(@Nullable String tab1Text) {
            this.tab1Text = tab1Text;
            return this;
        }

        public Builder tab0Text(@Nullable String tab0Text) {
            this.tab0Text = tab0Text;
            return this;
        }

        public Builder buttonOkText(@Nullable String buttonOkText) {
            this.buttonOkText = buttonOkText;
            return this;
        }

        public Builder secondDateAfterFirst(boolean secondDateAfterFirst) {
            this.secondDateAfterFirst = secondDateAfterFirst;
            return this;
        }

        public Builder setTab0DisplayDays(boolean tab0Days) {
            this.tab0Days = tab0Days;
            return this;
        }

        public Builder setTab0DisplayHours(boolean tab0Hours) {
            this.tab0Hours = tab0Hours;
            return this;
        }

        public Builder setTab0DisplayMinutes(boolean tab0Minutes) {
            this.tab0Minutes = tab0Minutes;
            return this;
        }

        public Builder setTab1DisplayDays(boolean tab1Days) {
            this.tab1Days = tab1Days;
            return this;
        }

        public Builder setTab1DisplayHours(boolean tab1Hours) {
            this.tab1Hours = tab1Hours;
            return this;
        }

        public Builder setTab1DisplayMinutes(boolean tab1Minutes) {
            this.tab1Minutes = tab1Minutes;
            return this;
        }

        public Builder setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public DoubleDateAndTimePickerDialog build() {
            DoubleDateAndTimePickerDialog dialog = new DoubleDateAndTimePickerDialog(this.context, this.bottomSheet).setTitle(this.title).setTitleTextSize(this.titleTextSize).setBottomSheetHeight(this.bottomSheetHeight).setTodayText(this.todayText).setListener(this.listener).setCurved(this.curved).setButtonOkText(this.buttonOkText).setTab0Text(this.tab0Text).setTab1Text(this.tab1Text).setMinutesStep(this.minutesStep).setMaxDateRange(this.maxDate).setMinDateRange(this.minDate).setDefaultDate(this.defaultDate).setTab0DisplayDays(this.tab0Days).setTab0DisplayHours(this.tab0Hours).setTab0DisplayMinutes(this.tab0Minutes).setTab1DisplayDays(this.tab1Days).setTab1DisplayHours(this.tab1Hours).setTab1DisplayMinutes(this.tab1Minutes).setTab0Date(this.tab0Date).setTab1Date(this.tab1Date).setDayFormatter(this.dayFormatter).setCustomLocale(this.customLocale).setMustBeOnFuture(this.mustBeOnFuture).setSecondDateAfterFirst(this.secondDateAfterFirst).setTimeZone(this.timeZone);
            if (this.mainColor != null) {
                dialog.setMainColor(this.mainColor);
            }
            if (this.backgroundColor != null) {
                dialog.setBackgroundColor(this.backgroundColor);
            }
            if (this.titleTextColor != null) {
                dialog.setTitleTextColor(this.titleTextColor);
            }
            return dialog;
        }

        public void display() {
            this.dialog = this.build();
            this.dialog.display();
        }

        public void close() {
            if (this.dialog != null) {
                this.dialog.close();
            }
        }

        public void dismiss() {
            if (this.dialog != null) {
                this.dialog.dismiss();
            }
        }
    }

    public static interface Listener {
        public void onDateSelected(List<Date> var1);
    }
}

