/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateHelper {
    private static TimeZone timeZone = TimeZone.getDefault();

    public static void setTimeZone(TimeZone timeZoneValue) {
        timeZone = timeZoneValue;
    }

    public static TimeZone getTimeZone() {
        return timeZone;
    }

    public static Calendar getCalendarOfDate(Date date) {
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        calendar.setTimeZone(timeZone);
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        return calendar;
    }

    public static int getHour(Date date) {
        return DateHelper.getCalendarOfDate(date).get(10);
    }

    public static int getHourOfDay(Date date) {
        return DateHelper.getCalendarOfDate(date).get(10);
    }

    public static int getHour(Date date, boolean isAmPm) {
        if (isAmPm) {
            return DateHelper.getHourOfDay(date);
        }
        return DateHelper.getHour(date);
    }

    public static int getMinuteOf(Date date) {
        return DateHelper.getCalendarOfDate(date).get(12);
    }

    public static Date today() {
        Calendar now = Calendar.getInstance(Locale.getDefault());
        now.setTimeZone(timeZone);
        return now.getTime();
    }

    public static int getMonth(Date date) {
        return DateHelper.getCalendarOfDate(date).get(2);
    }

    public static int getDay(Date date) {
        return DateHelper.getCalendarOfDate(date).get(5);
    }
}

