/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.DateHelper;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class WheelDayPicker
extends WheelPicker<String> {
    private static final String DAY_FORMAT_PATTERN = "EEE d MMM";
    private SimpleDateFormat simpleDateFormat;
    private SimpleDateFormat customDateFormat;
    private OnDaySelectedListener onDaySelectedListener;

    public WheelDayPicker(Context context) {
        super(context);
    }

    public WheelDayPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
        this.simpleDateFormat = new SimpleDateFormat(DAY_FORMAT_PATTERN, this.getCurrentLocale());
    }

    @Override
    public void setCustomLocale(Locale customLocale) {
        super.setCustomLocale(customLocale);
        this.simpleDateFormat = new SimpleDateFormat(DAY_FORMAT_PATTERN, this.getCurrentLocale());
    }

    @Override
    protected String initDefault() {
        return this.getTodayText();
    }

    @NonNull
    private String getTodayText() {
        return this.getLocalizedString(R.string.picker_today);
    }

    @Override
    protected void onItemSelected(int position, String item) {
        if (this.onDaySelectedListener != null) {
            Date date = this.convertItemToDate(position);
            this.onDaySelectedListener.onDaySelected(this, position, item, date);
        }
    }

    @Override
    protected List<String> generateAdapterValues() {
        int i;
        ArrayList<String> days = new ArrayList<String>();
        Calendar instance = Calendar.getInstance();
        instance.add(5, -365);
        for (i = -364; i < 0; ++i) {
            instance.add(5, 1);
            days.add(this.getFormattedValue(instance.getTime()));
        }
        days.add(this.getTodayText());
        instance = Calendar.getInstance();
        for (i = 0; i < 364; ++i) {
            instance.add(5, 1);
            days.add(this.getFormattedValue(instance.getTime()));
        }
        return days;
    }

    @Override
    protected String getFormattedValue(Object value) {
        return this.getDateFormat().format(value);
    }

    public WheelDayPicker setDayFormatter(SimpleDateFormat simpleDateFormat) {
        this.customDateFormat = simpleDateFormat;
        this.updateAdapter();
        return this;
    }

    public void setOnDaySelectedListener(OnDaySelectedListener onDaySelectedListener) {
        this.onDaySelectedListener = onDaySelectedListener;
    }

    public Date getCurrentDate() {
        return this.convertItemToDate(super.getCurrentItemPosition());
    }

    private SimpleDateFormat getDateFormat() {
        if (this.customDateFormat != null) {
            return this.customDateFormat;
        }
        return this.simpleDateFormat;
    }

    private Date convertItemToDate(int itemPosition) {
        Date date = null;
        String itemText = this.adapter.getItemText(itemPosition);
        Calendar todayCalendar = Calendar.getInstance();
        int todayPosition = this.adapter.getData().indexOf(this.getTodayText());
        if (this.getTodayText().equals(itemText)) {
            date = todayCalendar.getTime();
        } else {
            try {
                date = this.getDateFormat().parse(itemText);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (date != null) {
            Calendar dateCalendar = DateHelper.getCalendarOfDate(date);
            todayCalendar.add(5, itemPosition - todayPosition);
            dateCalendar.set(1, todayCalendar.get(1));
            date = dateCalendar.getTime();
        }
        return date;
    }

    public void setTodayText(String todayText) {
        int index = this.adapter.getData().indexOf(this.getTodayText());
        if (index != -1) {
            this.adapter.getData().set(index, todayText);
            this.notifyDatasetChanged();
        }
    }

    public static interface OnDaySelectedListener {
        public void onDaySelected(WheelDayPicker var1, int var2, String var3, Date var4);
    }
}

