/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.DateHelper;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class WheelMinutePicker
extends WheelPicker<String> {
    private int stepMinutes;
    private OnMinuteChangedListener onMinuteChangedListener;
    private OnFinishedLoopListener onFinishedLoopListener;

    public WheelMinutePicker(Context context) {
        super(context);
    }

    public WheelMinutePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
        this.stepMinutes = 5;
    }

    @Override
    protected String initDefault() {
        return this.getFormattedValue(Calendar.getInstance().get(12));
    }

    @Override
    protected List<String> generateAdapterValues() {
        ArrayList<String> minutes = new ArrayList<String>();
        for (int min = 0; min <= 59; min += this.stepMinutes) {
            minutes.add(this.getFormattedValue(min));
        }
        return minutes;
    }

    private int findIndexOfMinute(int minute) {
        int itemCount = this.adapter.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            String object = this.adapter.getItemText(i);
            Integer value = Integer.valueOf(object);
            if (minute == value) {
                return i;
            }
            if (minute >= value) continue;
            return i - 1;
        }
        return 0;
    }

    @Override
    public int findIndexOfDate(@NonNull Date date) {
        return this.findIndexOfMinute(DateHelper.getMinuteOf(date));
    }

    @Override
    protected String getFormattedValue(Object value) {
        Object valueItem = value;
        if (value instanceof Date) {
            Calendar instance = Calendar.getInstance();
            instance.setTime((Date)value);
            valueItem = instance.get(12);
        }
        return String.format(this.getCurrentLocale(), "%1$02d", valueItem);
    }

    public void setStepMinutes(int stepMinutes) {
        if (stepMinutes < 60 && stepMinutes > 0) {
            this.stepMinutes = stepMinutes;
            this.updateAdapter();
        }
    }

    private int convertItemToMinute(Object item) {
        return Integer.valueOf(String.valueOf(item));
    }

    public int getCurrentMinute() {
        return this.convertItemToMinute(this.adapter.getItem(this.getCurrentItemPosition()));
    }

    public WheelMinutePicker setOnMinuteChangedListener(OnMinuteChangedListener onMinuteChangedListener) {
        this.onMinuteChangedListener = onMinuteChangedListener;
        return this;
    }

    public WheelMinutePicker setOnFinishedLoopListener(OnFinishedLoopListener onFinishedLoopListener) {
        this.onFinishedLoopListener = onFinishedLoopListener;
        return this;
    }

    @Override
    protected void onItemSelected(int position, String item) {
        super.onItemSelected(position, item);
        if (this.onMinuteChangedListener != null) {
            this.onMinuteChangedListener.onMinuteChanged(this, this.convertItemToMinute(item));
        }
    }

    @Override
    protected void onFinishedLoop() {
        super.onFinishedLoop();
        if (this.onFinishedLoopListener != null) {
            this.onFinishedLoopListener.onFinishedLoop(this);
        }
    }

    public static interface OnFinishedLoopListener {
        public void onFinishedLoop(WheelMinutePicker var1);
    }

    public static interface OnMinuteChangedListener {
        public void onMinuteChanged(WheelMinutePicker var1, int var2);
    }
}

