/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.DateHelper;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class WheelAmPmPicker
extends WheelPicker<String> {
    public static final int INDEX_AM = 0;
    public static final int INDEX_PM = 1;
    @Nullable
    private AmPmListener amPmListener;

    public WheelAmPmPicker(Context context) {
        super(context);
    }

    public WheelAmPmPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
    }

    @Override
    protected String initDefault() {
        if (DateHelper.getHour(DateHelper.today(), true) >= 12) {
            return this.getContext().getString(R.string.picker_pm);
        }
        return this.getContext().getString(R.string.picker_am);
    }

    @Override
    protected List<String> generateAdapterValues() {
        return Arrays.asList(this.getContext().getString(R.string.picker_am), this.getContext().getString(R.string.picker_pm));
    }

    @Override
    public int findIndexOfDate(@NonNull Date date) {
        int hours = date.getHours();
        if (hours >= 12) {
            return 1;
        }
        return 0;
    }

    public void setAmPmListener(@Nullable AmPmListener amPmListener) {
        this.amPmListener = amPmListener;
    }

    @Override
    protected void onItemSelected(int position, String item) {
        super.onItemSelected(position, item);
        if (this.amPmListener != null) {
            this.amPmListener.onAmPmChanged(this, this.isAm());
        }
    }

    @Override
    public void setCyclic(boolean isCyclic) {
        super.setCyclic(false);
    }

    public boolean isAmPosition(int position) {
        return position == 0;
    }

    @Override
    protected String getFormattedValue(Object value) {
        if (value instanceof Date) {
            Calendar instance = Calendar.getInstance();
            instance.setTime((Date)value);
            return this.getResources().getString(instance.get(9) == 1 ? R.string.picker_pm : R.string.picker_am);
        }
        return String.valueOf(value);
    }

    public boolean isAm() {
        return this.getCurrentItemPosition() == 0;
    }

    public boolean isPm() {
        return this.getCurrentItemPosition() == 1;
    }

    public static interface AmPmListener {
        public void onAmPmChanged(WheelAmPmPicker var1, boolean var2);
    }
}

