/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.widget;

import android.content.Context;
import android.util.AttributeSet;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.widget.WheelPicker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class WheelDayPicker
extends WheelPicker {
    public static final int DAYS_PADDING = 364;
    private int defaultIndex;
    private int todayPosition;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE d MMM", this.getCurrentLocale());
    private OnDaySelectedListener onDaySelectedListener;
    WheelPicker.Adapter adapter = new WheelPicker.Adapter();

    public WheelDayPicker(Context context) {
        this(context, null);
    }

    public WheelDayPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setAdapter(this.adapter);
        this.updateDays();
        this.updateDefaultDay();
    }

    @Override
    protected void onItemSelected(int position, Object item) {
        if (null != this.onDaySelectedListener) {
            String itemText = (String)item;
            Date date = this.convertItemToDate(position);
            this.onDaySelectedListener.onDaySelected(this, position, itemText, date);
        }
    }

    @Override
    protected void onItemCurrentScroll(int position, Object item) {
    }

    @Override
    public int getDefaultItemPosition() {
        return this.defaultIndex;
    }

    private void updateDays() {
        int i;
        ArrayList<String> data = new ArrayList<String>();
        Calendar instance = Calendar.getInstance();
        instance.add(5, -365);
        for (i = -364; i < 0; ++i) {
            instance.add(5, 1);
            data.add(this.getFormattedValue(instance.getTime()));
        }
        this.defaultIndex = this.todayPosition = data.size();
        data.add(this.getResources().getString(R.string.picker_today));
        instance = Calendar.getInstance();
        for (i = 0; i < 364; ++i) {
            instance.add(5, 1);
            data.add(this.getFormattedValue(instance.getTime()));
        }
        this.adapter.setData(data);
    }

    @Override
    protected String getFormattedValue(Object value) {
        return this.simpleDateFormat.format(value);
    }

    public void setOnDaySelectedListener(OnDaySelectedListener onDaySelectedListener) {
        this.onDaySelectedListener = onDaySelectedListener;
    }

    private void updateDefaultDay() {
        this.setSelectedItemPosition(this.defaultIndex);
    }

    public int getDefaultDayIndex() {
        return this.defaultIndex;
    }

    public Date getCurrentDate() {
        return this.convertItemToDate(super.getCurrentItemPosition());
    }

    private Date convertItemToDate(int itemPosition) {
        Date date = null;
        String itemText = this.adapter.getItemText(itemPosition);
        Calendar todayCalendar = Calendar.getInstance();
        if (itemPosition == this.todayPosition) {
            date = todayCalendar.getTime();
        } else {
            try {
                date = this.simpleDateFormat.parse(itemText);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (date != null) {
            Calendar dateCalendar = Calendar.getInstance();
            dateCalendar.setTime(date);
            todayCalendar.add(5, itemPosition - this.todayPosition);
            dateCalendar.set(1, todayCalendar.get(1));
            date = dateCalendar.getTime();
        }
        return date;
    }

    public String getCurrentDay() {
        return this.adapter.getItemText(this.getCurrentItemPosition());
    }

    public static interface OnDaySelectedListener {
        public void onDaySelected(WheelDayPicker var1, int var2, String var3, Date var4);
    }
}

