/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.singledateandtimepicker.dialog;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import com.github.florent37.singledateandtimepicker.R;
import com.github.florent37.singledateandtimepicker.SingleDateAndTimePicker;
import com.github.florent37.singledateandtimepicker.dialog.BaseDialog;
import com.github.florent37.singledateandtimepicker.dialog.BottomSheetHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class DoubleDateAndTimePickerDialog
extends BaseDialog {
    private Listener listener;
    private BottomSheetHelper bottomSheetHelper;
    private TextView buttonTab0;
    private TextView buttonTab1;
    private TextView buttonOk;
    private SingleDateAndTimePicker pickerTab0;
    private SingleDateAndTimePicker pickerTab1;
    private View tab0;
    private View tab1;
    private boolean okClicked = false;
    @Nullable
    private String tab0Text;
    @Nullable
    private String tab1Text;
    @Nullable
    private String title;
    @Nullable
    private String buttonOkText;
    private boolean curved = false;

    private DoubleDateAndTimePickerDialog(Context context) {
        this(context, false);
    }

    private DoubleDateAndTimePickerDialog(Context context, boolean bottomSheet) {
        int layout2 = bottomSheet ? R.layout.bottom_sheet_double_picker_bottom_sheet : R.layout.bottom_sheet_double_picker;
        this.bottomSheetHelper = new BottomSheetHelper(context, layout2);
        this.bottomSheetHelper.setListener(new BottomSheetHelper.Listener(){

            @Override
            public void onOpen() {
            }

            @Override
            public void onLoaded(View view) {
                DoubleDateAndTimePickerDialog.this.init(view);
            }

            @Override
            public void onClose() {
                DoubleDateAndTimePickerDialog.this.onClose();
            }
        });
    }

    private void init(View view) {
        this.buttonTab0 = (TextView)view.findViewById(R.id.buttonTab0);
        this.buttonTab1 = (TextView)view.findViewById(R.id.buttonTab1);
        this.pickerTab0 = (SingleDateAndTimePicker)view.findViewById(R.id.picker_tab_0);
        this.pickerTab1 = (SingleDateAndTimePicker)view.findViewById(R.id.picker_tab_1);
        this.tab0 = view.findViewById(R.id.tab0);
        this.tab1 = view.findViewById(R.id.tab1);
        TextView titleTextView = (TextView)view.findViewById(R.id.sheetTitle);
        if (titleTextView != null) {
            titleTextView.setText((CharSequence)this.title);
        }
        view.findViewById(R.id.sheetContentLayout).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.tab1.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                DoubleDateAndTimePickerDialog.this.tab1.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                DoubleDateAndTimePickerDialog.this.tab1.setTranslationX((float)DoubleDateAndTimePickerDialog.this.tab1.getWidth());
                return false;
            }
        });
        this.buttonTab0.setSelected(true);
        if (this.tab0Text != null) {
            this.buttonTab0.setText((CharSequence)this.tab0Text);
        }
        this.buttonTab0.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DoubleDateAndTimePickerDialog.this.displayTab0();
            }
        });
        if (this.tab1Text != null) {
            this.buttonTab1.setText((CharSequence)this.tab1Text);
        }
        this.buttonTab1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DoubleDateAndTimePickerDialog.this.displayTab1();
            }
        });
        this.buttonOk = (TextView)view.findViewById(R.id.buttonOk);
        if (this.buttonOkText != null) {
            this.buttonOk.setText((CharSequence)this.buttonOkText);
        }
        this.buttonOk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (DoubleDateAndTimePickerDialog.this.isTab0Visible()) {
                    DoubleDateAndTimePickerDialog.this.displayTab1();
                } else {
                    DoubleDateAndTimePickerDialog.this.okClicked = true;
                    DoubleDateAndTimePickerDialog.this.close();
                }
            }
        });
        if (this.curved) {
            this.pickerTab0.setCurved(true);
            this.pickerTab1.setCurved(true);
            this.pickerTab0.setVisibleItemCount(7);
            this.pickerTab1.setVisibleItemCount(7);
        } else {
            this.pickerTab0.setCurved(false);
            this.pickerTab1.setCurved(false);
            this.pickerTab0.setVisibleItemCount(5);
            this.pickerTab1.setVisibleItemCount(5);
        }
    }

    public DoubleDateAndTimePickerDialog setTab0Text(String tab0Text) {
        this.tab0Text = tab0Text;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTab1Text(String tab1Text) {
        this.tab1Text = tab1Text;
        return this;
    }

    public DoubleDateAndTimePickerDialog setButtonOkText(@Nullable String buttonOkText) {
        this.buttonOkText = buttonOkText;
        return this;
    }

    public DoubleDateAndTimePickerDialog setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    public DoubleDateAndTimePickerDialog setListener(Listener listener) {
        this.listener = listener;
        return this;
    }

    public DoubleDateAndTimePickerDialog setCurved(boolean curved) {
        this.curved = curved;
        return this;
    }

    @Override
    public void display() {
        super.display();
        this.bottomSheetHelper.display();
    }

    @Override
    public void close() {
        super.close();
        this.bottomSheetHelper.hide();
    }

    @Override
    protected void onClose() {
        super.onClose();
        if (this.listener != null && this.okClicked) {
            this.listener.onDateSelected(Arrays.asList(this.pickerTab0.getDate(), this.pickerTab1.getDate()));
        }
    }

    private void displayTab0() {
        if (!this.isTab0Visible()) {
            this.buttonTab0.setSelected(true);
            this.buttonTab1.setSelected(false);
            this.tab0.animate().translationX(0.0f);
            this.tab1.animate().translationX((float)this.tab1.getWidth());
        }
    }

    private void displayTab1() {
        if (this.isTab0Visible()) {
            this.buttonTab0.setSelected(false);
            this.buttonTab1.setSelected(true);
            this.tab0.animate().translationX((float)(-this.tab0.getWidth()));
            this.tab1.animate().translationX(0.0f);
        }
    }

    private boolean isTab0Visible() {
        return this.tab0.getTranslationX() == 0.0f;
    }

    public static class Builder {
        private final Context context;
        @Nullable
        private Listener listener;
        private boolean bottomSheet;
        private boolean curved;
        private DoubleDateAndTimePickerDialog dialog;
        @Nullable
        private String tab0Text;
        @Nullable
        private String tab1Text;
        @Nullable
        private String title;
        @Nullable
        private String buttonOkText;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public Builder bottomSheet() {
            this.bottomSheet = true;
            return this;
        }

        public Builder curved() {
            this.curved = true;
            return this;
        }

        public Builder listener(@Nullable Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder tab1Text(@Nullable String tab1Text) {
            this.tab1Text = tab1Text;
            return this;
        }

        public Builder tab0Text(@Nullable String tab0Text) {
            this.tab0Text = tab0Text;
            return this;
        }

        public Builder bButtonOkText(@Nullable String buttonOkText) {
            this.buttonOkText = buttonOkText;
            return this;
        }

        public DoubleDateAndTimePickerDialog build() {
            return new DoubleDateAndTimePickerDialog(this.context, this.bottomSheet).setTitle(this.title).setListener(this.listener).setCurved(this.curved).setButtonOkText(this.buttonOkText).setTab0Text(this.tab0Text).setTab1Text(this.tab1Text);
        }

        public void display() {
            this.dialog = this.build();
            this.dialog.display();
        }

        public void close() {
            if (this.dialog != null) {
                this.dialog.close();
            }
        }
    }

    public static interface Listener {
        public void onDateSelected(List<Date> var1);
    }
}

