/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class ArcView
extends ShapeOfView {
    public static final int POSITION_BOTTOM = 1;
    public static final int POSITION_TOP = 2;
    public static final int POSITION_LEFT = 3;
    public static final int POSITION_RIGHT = 4;
    public static final int CROP_INSIDE = 1;
    public static final int CROP_OUTSIDE = 2;
    @ArcPosition
    private int arcPosition = 2;
    @CropDirection
    private int cropDirection = 1;
    private float arcHeightPx = 0.0f;

    public ArcView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public ArcView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ArcView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.ArcView);
            this.arcHeightPx = attributes.getDimensionPixelSize(R.styleable.ArcView_shape_arc_height, (int)this.arcHeightPx);
            this.arcPosition = attributes.getInteger(R.styleable.ArcView_shape_arc_position, this.arcPosition);
            this.cropDirection = attributes.getInteger(R.styleable.ArcView_shape_arc_cropDirection, this.cropDirection);
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                Path path = new Path();
                boolean isCropInside = ArcView.this.cropDirection == 1;
                switch (ArcView.this.arcPosition) {
                    case 1: {
                        if (isCropInside) {
                            path.moveTo(0.0f, 0.0f);
                            path.lineTo(0.0f, (float)height);
                            path.quadTo((float)(width / 2), (float)height - 2.0f * ArcView.this.arcHeightPx, (float)width, (float)height);
                            path.lineTo((float)width, 0.0f);
                            path.close();
                            break;
                        }
                        path.moveTo(0.0f, 0.0f);
                        path.lineTo(0.0f, (float)height - ArcView.this.arcHeightPx);
                        path.quadTo((float)(width / 2), (float)height + ArcView.this.arcHeightPx, (float)width, (float)height - ArcView.this.arcHeightPx);
                        path.lineTo((float)width, 0.0f);
                        path.close();
                        break;
                    }
                    case 2: {
                        if (isCropInside) {
                            path.moveTo(0.0f, (float)height);
                            path.lineTo(0.0f, 0.0f);
                            path.quadTo((float)(width / 2), 2.0f * ArcView.this.arcHeightPx, (float)width, 0.0f);
                            path.lineTo((float)width, (float)height);
                            path.close();
                            break;
                        }
                        path.moveTo(0.0f, ArcView.this.arcHeightPx);
                        path.quadTo((float)(width / 2), -ArcView.this.arcHeightPx, (float)width, ArcView.this.arcHeightPx);
                        path.lineTo((float)width, (float)height);
                        path.lineTo(0.0f, (float)height);
                        path.close();
                        break;
                    }
                    case 3: {
                        if (isCropInside) {
                            path.moveTo((float)width, 0.0f);
                            path.lineTo(0.0f, 0.0f);
                            path.quadTo(ArcView.this.arcHeightPx * 2.0f, (float)(height / 2), 0.0f, (float)height);
                            path.lineTo((float)width, (float)height);
                            path.close();
                            break;
                        }
                        path.moveTo((float)width, 0.0f);
                        path.lineTo(ArcView.this.arcHeightPx, 0.0f);
                        path.quadTo(-ArcView.this.arcHeightPx, (float)(height / 2), ArcView.this.arcHeightPx, (float)height);
                        path.lineTo((float)width, (float)height);
                        path.close();
                        break;
                    }
                    case 4: {
                        if (isCropInside) {
                            path.moveTo(0.0f, 0.0f);
                            path.lineTo((float)width, 0.0f);
                            path.quadTo((float)width - ArcView.this.arcHeightPx * 2.0f, (float)(height / 2), (float)width, (float)height);
                            path.lineTo(0.0f, (float)height);
                            path.close();
                            break;
                        }
                        path.moveTo(0.0f, 0.0f);
                        path.lineTo((float)width - ArcView.this.arcHeightPx, 0.0f);
                        path.quadTo((float)width + ArcView.this.arcHeightPx, (float)(height / 2), (float)width - ArcView.this.arcHeightPx, (float)height);
                        path.lineTo(0.0f, (float)height);
                        path.close();
                    }
                }
                return path;
            }

            @Override
            public boolean requiresBitmap() {
                return false;
            }
        });
    }

    public int getArcPosition() {
        return this.arcPosition;
    }

    public void setArcPosition(@ArcPosition int arcPosition) {
        this.arcPosition = arcPosition;
        this.requiresShapeUpdate();
    }

    public int getCropDirection() {
        return this.cropDirection;
    }

    public void setCropDirection(@CropDirection int cropDirection) {
        this.cropDirection = cropDirection;
        this.requiresShapeUpdate();
    }

    public float getArcHeight() {
        return this.arcHeightPx;
    }

    public void setArcHeight(float arcHeight) {
        this.arcHeightPx = arcHeight;
        this.requiresShapeUpdate();
    }

    public float getArcHeightDp() {
        return this.pxToDp(this.arcHeightPx);
    }

    public void setArcHeightDp(float arcHeight) {
        this.setArcHeight(this.dpToPx(arcHeight));
    }

    public static @interface CropDirection {
    }

    public static @interface ArcPosition {
    }
}

