/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class StarView
extends ShapeOfView {
    private int noOfPoints = 5;

    public StarView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public StarView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public StarView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.StarView);
            int points = attributes.getInteger(R.styleable.StarView_shape_star_noOfPoints, this.noOfPoints);
            this.noOfPoints = points > 2 ? points : this.noOfPoints;
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                int vertices = StarView.this.noOfPoints * 2;
                float alpha = (float)Math.PI * 2 / (float)vertices;
                int radius = (height <= width ? height : width) / 2;
                float centerX = width / 2;
                float centerY = height / 2;
                Path path = new Path();
                for (int i = vertices + 1; i != 0; --i) {
                    float r = radius * (i % 2 + 1) / 2;
                    double omega = alpha * (float)i;
                    path.lineTo((float)((double)r * Math.sin(omega)) + centerX, (float)((double)r * Math.cos(omega)) + centerY);
                }
                path.close();
                return path;
            }

            @Override
            public boolean requiresBitmap() {
                return true;
            }
        });
    }

    public void setNoOfPoints(int noOfPoints) {
        this.noOfPoints = noOfPoints;
        this.requiresShapeUpdate();
    }

    public int getNoOfPoints() {
        return this.noOfPoints;
    }
}

