/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.manager;

import android.graphics.Paint;
import android.graphics.Path;
import androidx.annotation.Nullable;
import com.github.florent37.shapeofview.manager.ClipManager;

public class ClipPathManager
implements ClipManager {
    protected final Path path = new Path();
    private final Paint paint = new Paint(1);
    private ClipPathCreator createClipPath = null;

    public ClipPathManager() {
        this.paint.setColor(-16777216);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        this.paint.setStrokeWidth(1.0f);
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public boolean requiresBitmap() {
        return this.createClipPath != null && this.createClipPath.requiresBitmap();
    }

    @Nullable
    protected final Path createClipPath(int width, int height) {
        if (this.createClipPath != null) {
            return this.createClipPath.createClipPath(width, height);
        }
        return null;
    }

    public void setClipPathCreator(ClipPathCreator createClipPath) {
        this.createClipPath = createClipPath;
    }

    @Override
    public Path createMask(int width, int height) {
        return this.path;
    }

    @Override
    @Nullable
    public Path getShadowConvexPath() {
        return this.path;
    }

    @Override
    public void setupClipLayout(int width, int height) {
        this.path.reset();
        Path clipPath = this.createClipPath(width, height);
        if (clipPath != null) {
            this.path.set(clipPath);
        }
    }

    public static interface ClipPathCreator {
        public Path createClipPath(int var1, int var2);

        public boolean requiresBitmap();
    }
}

