/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class RoundRectView
extends ShapeOfView {
    private final RectF rectF = new RectF();
    private int topLeftRadius;
    private int topRightRadius;
    private int bottomRightRadius;
    private int bottomLeftRadius;

    public RoundRectView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public RoundRectView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RoundRectView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.RoundRectView);
            this.topLeftRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_roundRect_topLeftRadius, this.topLeftRadius);
            this.topRightRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_roundRect_topRightRadius, this.topRightRadius);
            this.bottomLeftRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_roundRect_bottomLeftRadius, this.bottomLeftRadius);
            this.bottomRightRadius = attributes.getDimensionPixelSize(R.styleable.RoundRectView_roundRect_bottomRightRadius, this.bottomRightRadius);
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                RoundRectView.this.rectF.set(0.0f, 0.0f, (float)width, (float)height);
                return RoundRectView.this.generatePath(RoundRectView.this.rectF, RoundRectView.this.limitSize(RoundRectView.this.topLeftRadius, width, height), RoundRectView.this.limitSize(RoundRectView.this.topRightRadius, width, height), RoundRectView.this.limitSize(RoundRectView.this.bottomRightRadius, width, height), RoundRectView.this.limitSize(RoundRectView.this.bottomLeftRadius, width, height));
            }
        });
    }

    protected float limitSize(float from, float width, float height) {
        return Math.min(from, Math.min(width, height));
    }

    private Path generatePath(RectF rect, float topLeftRadius, float topRightRadius, float bottomRightRadius, float bottomLeftRadius) {
        Path path = new Path();
        topLeftRadius = topLeftRadius < 0.0f ? 0.0f : topLeftRadius;
        topRightRadius = topRightRadius < 0.0f ? 0.0f : topRightRadius;
        bottomLeftRadius = bottomLeftRadius < 0.0f ? 0.0f : bottomLeftRadius;
        bottomRightRadius = bottomRightRadius < 0.0f ? 0.0f : bottomRightRadius;
        path.moveTo(rect.left + topLeftRadius, rect.top);
        path.lineTo(rect.right - topRightRadius, rect.top);
        path.quadTo(rect.right, rect.top, rect.right, rect.top + topRightRadius);
        path.lineTo(rect.right, rect.bottom - bottomRightRadius);
        path.quadTo(rect.right, rect.bottom, rect.right - bottomRightRadius, rect.bottom);
        path.lineTo(rect.left + bottomLeftRadius, rect.bottom);
        path.quadTo(rect.left, rect.bottom, rect.left, rect.bottom - bottomLeftRadius);
        path.lineTo(rect.left, rect.top + topLeftRadius);
        path.quadTo(rect.left, rect.top, rect.left + topLeftRadius, rect.top);
        path.close();
        return path;
    }

    public int getTopLeftRadius() {
        return this.topLeftRadius;
    }

    public void setTopLeftRadius(int topLeftRadius) {
        this.topLeftRadius = topLeftRadius;
        this.postInvalidate();
    }

    public int getTopRightRadius() {
        return this.topRightRadius;
    }

    public void setTopRightRadius(int topRightRadius) {
        this.topRightRadius = topRightRadius;
        this.postInvalidate();
    }

    public int getBottomRightRadius() {
        return this.bottomRightRadius;
    }

    public void setBottomRightRadius(int bottomRightRadius) {
        this.bottomRightRadius = bottomRightRadius;
        this.postInvalidate();
    }

    public int getBottomLeftRadius() {
        return this.bottomLeftRadius;
    }

    public void setBottomLeftRadius(int bottomLeftRadius) {
        this.bottomLeftRadius = bottomLeftRadius;
        this.postInvalidate();
    }
}

