/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class RoundRectView
extends ShapeOfView {
    private final RectF rectF = new RectF();
    private int topLeftDiameter;
    private int topRightDiameter;
    private int bottomRightDiameter;
    private int bottomLeftDiameter;

    public RoundRectView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public RoundRectView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RoundRectView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.RoundRectView);
            this.topLeftDiameter = attributes.getDimensionPixelSize(R.styleable.RoundRectView_roundRect_topLeftDiameter, this.topLeftDiameter);
            this.topRightDiameter = attributes.getDimensionPixelSize(R.styleable.RoundRectView_roundRect_topRightDiameter, this.topRightDiameter);
            this.bottomLeftDiameter = attributes.getDimensionPixelSize(R.styleable.RoundRectView_roundRect_bottomLeftDiameter, this.bottomLeftDiameter);
            this.bottomRightDiameter = attributes.getDimensionPixelSize(R.styleable.RoundRectView_roundRect_bottomRightDiameter, this.bottomRightDiameter);
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                RoundRectView.this.rectF.set(0.0f, 0.0f, (float)width, (float)height);
                return RoundRectView.this.generatePath(RoundRectView.this.rectF, RoundRectView.this.topLeftDiameter, RoundRectView.this.topRightDiameter, RoundRectView.this.bottomRightDiameter, RoundRectView.this.bottomLeftDiameter);
            }
        });
    }

    private Path generatePath(RectF rect, float topLeftDiameter, float topRightDiameter, float bottomRightDiameter, float bottomLeftDiameter) {
        Path path = new Path();
        topLeftDiameter = topLeftDiameter < 0.0f ? 0.0f : topLeftDiameter;
        topRightDiameter = topRightDiameter < 0.0f ? 0.0f : topRightDiameter;
        bottomLeftDiameter = bottomLeftDiameter < 0.0f ? 0.0f : bottomLeftDiameter;
        bottomRightDiameter = bottomRightDiameter < 0.0f ? 0.0f : bottomRightDiameter;
        path.moveTo(rect.left + topLeftDiameter, rect.top);
        path.lineTo(rect.right - topRightDiameter, rect.top);
        path.quadTo(rect.right, rect.top, rect.right, rect.top + topRightDiameter);
        path.lineTo(rect.right, rect.bottom - bottomRightDiameter);
        path.quadTo(rect.right, rect.bottom, rect.right - bottomRightDiameter, rect.bottom);
        path.lineTo(rect.left + bottomLeftDiameter, rect.bottom);
        path.quadTo(rect.left, rect.bottom, rect.left, rect.bottom - bottomLeftDiameter);
        path.lineTo(rect.left, rect.top + topLeftDiameter);
        path.quadTo(rect.left, rect.top, rect.left + topLeftDiameter, rect.top);
        path.close();
        return path;
    }

    public int getTopLeftDiameter() {
        return this.topLeftDiameter;
    }

    public void setTopLeftDiameter(int topLeftDiameter) {
        this.topLeftDiameter = topLeftDiameter;
        this.postInvalidate();
    }

    public int getTopRightDiameter() {
        return this.topRightDiameter;
    }

    public void setTopRightDiameter(int topRightDiameter) {
        this.topRightDiameter = topRightDiameter;
        this.postInvalidate();
    }

    public int getBottomRightDiameter() {
        return this.bottomRightDiameter;
    }

    public void setBottomRightDiameter(int bottomRightDiameter) {
        this.bottomRightDiameter = bottomRightDiameter;
        this.postInvalidate();
    }

    public int getBottomLeftDiameter() {
        return this.bottomLeftDiameter;
    }

    public void setBottomLeftDiameter(int bottomLeftDiameter) {
        this.bottomLeftDiameter = bottomLeftDiameter;
        this.postInvalidate();
    }
}

