/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.runtimepermission;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.runtimepermission.RuntimePermission;
import java.util.ArrayList;
import java.util.List;

public class PermissionResult {
    private final RuntimePermission runtimePermission;
    @NonNull
    private final List<String> accepted = new ArrayList<String>();
    @NonNull
    private final List<String> foreverDenied = new ArrayList<String>();
    @NonNull
    private final List<String> denied = new ArrayList<String>();

    protected PermissionResult(RuntimePermission runtimePermission, @Nullable List<String> accepted, @Nullable List<String> foreverDenied, @Nullable List<String> denied) {
        this.runtimePermission = runtimePermission;
        if (accepted != null) {
            this.accepted.addAll(accepted);
        }
        if (foreverDenied != null) {
            this.foreverDenied.addAll(foreverDenied);
        }
        if (denied != null) {
            this.denied.addAll(denied);
        }
    }

    public void askAgain() {
        this.runtimePermission.ask();
    }

    public boolean isAccepted() {
        return this.foreverDenied.isEmpty() && this.denied.isEmpty();
    }

    @NonNull
    public RuntimePermission getRuntimePermission() {
        return this.runtimePermission;
    }

    public void goToSettings() {
        this.runtimePermission.goToSettings();
    }

    public boolean hasDenied() {
        return !this.denied.isEmpty();
    }

    public boolean hasForeverDenied() {
        return !this.foreverDenied.isEmpty();
    }

    @NonNull
    public List<String> getAccepted() {
        return this.accepted;
    }

    @NonNull
    public List<String> getForeverDenied() {
        return this.foreverDenied;
    }

    @NonNull
    public List<String> getDenied() {
        return this.denied;
    }
}

