/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.runtimepermission;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import com.github.florent37.runtimepermission.PermissionFragment;
import com.github.florent37.runtimepermission.PermissionManifestFinder;
import com.github.florent37.runtimepermission.PermissionResult;
import com.github.florent37.runtimepermission.callbacks.AcceptedCallback;
import com.github.florent37.runtimepermission.callbacks.DeniedCallback;
import com.github.florent37.runtimepermission.callbacks.ForeverDeniedCallback;
import com.github.florent37.runtimepermission.callbacks.PermissionListener;
import com.github.florent37.runtimepermission.callbacks.ResponseCallback;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RuntimePermission {
    private static final String TAG = "PERMISSION_FRAGMENT_WEEEEE";
    private final Reference<FragmentActivity> activityReference;
    private final List<String> permissionsToRequest = new ArrayList<String>();
    private final List<ResponseCallback> responseCallbacks = new ArrayList<ResponseCallback>();
    private final List<AcceptedCallback> acceptedCallbacks = new ArrayList<AcceptedCallback>();
    private final List<ForeverDeniedCallback> foreverDeniedCallbacks = new ArrayList<ForeverDeniedCallback>();
    private final List<DeniedCallback> deniedCallbacks = new ArrayList<DeniedCallback>();
    private final List<PermissionListener> permissionListeners = new ArrayList<PermissionListener>();
    private final PermissionFragment.PermissionListener listener = new PermissionFragment.PermissionListener(){

        @Override
        public void onRequestPermissionsResult(List<String> acceptedPermissions, List<String> refusedPermissions, List<String> askAgainPermissions) {
            RuntimePermission.this.onReceivedPermissionResult(acceptedPermissions, refusedPermissions, askAgainPermissions);
        }
    };

    public RuntimePermission(@Nullable FragmentActivity activity) {
        this.activityReference = activity != null ? new WeakReference<FragmentActivity>(activity) : new WeakReference<Object>(null);
    }

    public static RuntimePermission askPermission(@Nullable FragmentActivity activity, String ... permissions) {
        return new RuntimePermission(activity).request(permissions);
    }

    public static RuntimePermission askPermission(@Nullable Fragment fragment, String ... permissions) {
        FragmentActivity activity = null;
        if (fragment != null) {
            activity = fragment.getActivity();
        }
        return RuntimePermission.askPermission(activity, new String[0]).request(permissions);
    }

    public void goToSettings() {
        FragmentActivity fragmentActivity = this.activityReference.get();
        if (fragmentActivity != null) {
            fragmentActivity.startActivity(new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)fragmentActivity.getPackageName(), null)));
        }
    }

    private void onReceivedPermissionResult(List<String> acceptedPermissions, List<String> refusedPermissions, List<String> askAgainPermissions) {
        PermissionResult permissionResult = new PermissionResult(this, acceptedPermissions, refusedPermissions, askAgainPermissions);
        if (permissionResult.isAccepted()) {
            for (AcceptedCallback acceptedCallback : this.acceptedCallbacks) {
                acceptedCallback.onAccepted(permissionResult);
            }
            for (PermissionListener permissionListener : this.permissionListeners) {
                permissionListener.onAccepted(permissionResult, permissionResult.getAccepted());
            }
        }
        if (permissionResult.hasDenied()) {
            for (DeniedCallback deniedCallback : this.deniedCallbacks) {
                deniedCallback.onDenied(permissionResult);
            }
        }
        if (permissionResult.hasForeverDenied()) {
            for (ForeverDeniedCallback foreverDeniedCallback : this.foreverDeniedCallbacks) {
                foreverDeniedCallback.onForeverDenied(permissionResult);
            }
        }
        if (permissionResult.hasForeverDenied() || permissionResult.hasDenied()) {
            for (PermissionListener permissionListener : this.permissionListeners) {
                permissionListener.onDenied(permissionResult, permissionResult.getDenied(), permissionResult.getForeverDenied());
            }
        }
        for (ResponseCallback responseCallback : this.responseCallbacks) {
            responseCallback.onResponse(permissionResult);
        }
    }

    public RuntimePermission request(@Nullable List<String> permissions) {
        if (permissions != null) {
            this.permissionsToRequest.clear();
            this.permissionsToRequest.addAll(permissions);
        }
        return this;
    }

    public RuntimePermission request(String ... permissions) {
        if (permissions != null) {
            return this.request(Arrays.asList(permissions));
        }
        return this;
    }

    public RuntimePermission onResponse(@Nullable ResponseCallback callback) {
        if (callback != null) {
            this.responseCallbacks.add(callback);
        }
        return this;
    }

    public RuntimePermission onResponse(@Nullable PermissionListener permissionListener) {
        if (permissionListener != null) {
            this.permissionListeners.add(permissionListener);
        }
        return this;
    }

    public RuntimePermission onAccepted(@Nullable AcceptedCallback callback) {
        if (callback != null) {
            this.acceptedCallbacks.add(callback);
        }
        return this;
    }

    public RuntimePermission onDenied(@Nullable DeniedCallback callback) {
        if (callback != null) {
            this.deniedCallbacks.add(callback);
        }
        return this;
    }

    public RuntimePermission onForeverDenied(@Nullable ForeverDeniedCallback callback) {
        if (callback != null) {
            this.foreverDeniedCallbacks.add(callback);
        }
        return this;
    }

    public void ask(@Nullable ResponseCallback responseCallback) {
        this.onResponse(responseCallback).ask();
    }

    public void ask(@Nullable PermissionListener permissionListener) {
        this.onResponse(permissionListener).ask();
    }

    private List<String> findNeededPermissions(@NonNull Context context) {
        if (this.permissionsToRequest.isEmpty()) {
            return PermissionManifestFinder.findNeededPermissionsFromManifest(context);
        }
        return this.permissionsToRequest;
    }

    public void ask() {
        final FragmentActivity activity = this.activityReference.get();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        List<String> permissions = this.findNeededPermissions((Context)activity);
        if (permissions.isEmpty() || Build.VERSION.SDK_INT < 23 || this.arePermissionsAlreadyAccepted((Context)activity, permissions)) {
            this.onAllAccepted(permissions);
        } else {
            PermissionFragment oldFragment = (PermissionFragment)activity.getSupportFragmentManager().findFragmentByTag(TAG);
            if (oldFragment != null) {
                oldFragment.setListener(this.listener);
            } else {
                final PermissionFragment newFragment = PermissionFragment.newInstance(permissions);
                newFragment.setListener(this.listener);
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        activity.getSupportFragmentManager().beginTransaction().add((Fragment)newFragment, RuntimePermission.TAG).commitNowAllowingStateLoss();
                    }
                });
            }
        }
    }

    private boolean arePermissionsAlreadyAccepted(@NonNull Context context, @NonNull List<String> permissions) {
        for (String permission : permissions) {
            int permissionState = ContextCompat.checkSelfPermission((Context)context, (String)permission);
            if (permissionState != -1) continue;
            return false;
        }
        return true;
    }

    private void onAllAccepted(@NonNull List<String> permissions) {
        this.onReceivedPermissionResult(permissions, null, null);
    }

    public void askAgain() {
    }
}

