/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.kotlin.pleaseanimate.core.position;

import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.github.florent37.kotlin.pleaseanimate.core.position.PositionAnimExpectation;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0082\u0002J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/florent37/kotlin/pleaseanimate/core/position/PositionAnimExpectationOutOfScreen;", "Lcom/github/florent37/kotlin/pleaseanimate/core/position/PositionAnimExpectation;", "gravities", "", "([I)V", "windowManager", "Landroid/view/WindowManager;", "contains", "", "gravity", "", "getCalculatedValueX", "", "viewToMove", "Landroid/view/View;", "(Landroid/view/View;)Ljava/lang/Float;", "getCalculatedValueY", "kotlinpleaseanimate_release"})
public final class PositionAnimExpectationOutOfScreen
extends PositionAnimExpectation {
    private WindowManager windowManager;
    private final int[] gravities;

    private final boolean contains(int gravity) {
        return ArraysKt.contains((int[])this.gravities, (int)gravity);
    }

    @Override
    @Nullable
    public Float getCalculatedValueX(@NotNull View viewToMove) {
        Intrinsics.checkParameterIsNotNull((Object)viewToMove, (String)"viewToMove");
        if (this.contains(5) || this.contains(0x800005)) {
            if (this.windowManager == null) {
                Object object = viewToMove.getContext().getSystemService("window");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
                }
                this.windowManager = (WindowManager)object;
            }
            WindowManager windowManager = this.windowManager;
            if (windowManager == null) {
                Intrinsics.throwNpe();
            }
            Display display = windowManager.getDefaultDisplay();
            Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"windowManager!!.defaultDisplay");
            return Float.valueOf(display.getWidth());
        }
        return this.contains(3) || this.contains(0x800003) ? Float.valueOf(-1.0f * (float)viewToMove.getWidth()) : null;
    }

    @Override
    @Nullable
    public Float getCalculatedValueY(@NotNull View viewToMove) {
        Intrinsics.checkParameterIsNotNull((Object)viewToMove, (String)"viewToMove");
        if (this.contains(80)) {
            if (this.windowManager == null) {
                Object object = viewToMove.getContext().getSystemService("window");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
                }
                this.windowManager = (WindowManager)object;
            }
            WindowManager windowManager = this.windowManager;
            if (windowManager == null) {
                Intrinsics.throwNpe();
            }
            Display display = windowManager.getDefaultDisplay();
            Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"windowManager!!.defaultDisplay");
            return Float.valueOf(display.getHeight());
        }
        return this.contains(48) ? Float.valueOf(-1.0f * (float)viewToMove.getHeight()) : null;
    }

    public PositionAnimExpectationOutOfScreen(@NotNull int[] gravities) {
        Intrinsics.checkParameterIsNotNull((Object)gravities, (String)"gravities");
        this.gravities = gravities;
        this.setForPositionX(true);
        this.setForPositionY(true);
    }
}

