/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.expansionpanel;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.HorizontalScrollView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.expansionpanel.R;
import java.util.ArrayList;
import java.util.List;

public class HorizontalExpansionLayout
extends HorizontalScrollView {
    private final List<IndicatorListener> indicatorListeners = new ArrayList<IndicatorListener>();
    private final List<Listener> listeners = new ArrayList<Listener>();
    public Boolean singleListener = false;
    private boolean expanded = false;
    private Animator animator;

    public HorizontalExpansionLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public HorizontalExpansionLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public HorizontalExpansionLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray a;
        this.requestDisallowInterceptTouchEvent(true);
        if (attrs != null && (a = context.obtainStyledAttributes(attrs, R.styleable.ExpansionLayout)) != null) {
            this.expanded = a.getBoolean(R.styleable.ExpansionLayout_expansion_expanded, this.expanded);
            a.recycle();
        }
    }

    public void addListener(Listener listener) {
        if (this.singleListener.booleanValue()) {
            this.listeners.clear();
            this.listeners.add(listener);
        } else if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void addIndicatorListener(IndicatorListener listener) {
        if (listener != null && !this.indicatorListeners.contains(listener)) {
            this.indicatorListeners.add(listener);
        }
    }

    public void removeIndicatorListener(IndicatorListener listener) {
        if (listener != null) {
            this.indicatorListeners.remove(listener);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.expanded) {
            this.setWidth(0.0f);
        }
    }

    public void addView(View child) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ExpansionLayout can host only one direct child");
        }
        super.addView(child);
        this.onViewAdded();
    }

    public void addView(View child, int index) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ExpansionLayout can host only one direct child");
        }
        super.addView(child, index);
        this.onViewAdded();
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ExpansionLayout can host only one direct child");
        }
        super.addView(child, params);
        this.onViewAdded();
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ExpansionLayout can host only one direct child");
        }
        super.addView(child, index, params);
        this.onViewAdded();
    }

    private void onViewAdded() {
        if (this.getChildCount() != 0) {
            final View childView = this.getChildAt(0);
            childView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    childView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    if (HorizontalExpansionLayout.this.expanded) {
                        HorizontalExpansionLayout.this.expand(false);
                    }
                    childView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                        public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                            if (HorizontalExpansionLayout.this.expanded && HorizontalExpansionLayout.this.animator == null) {
                                final int width = right - left;
                                HorizontalExpansionLayout.this.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        HorizontalExpansionLayout.this.setWidth(width);
                                    }
                                });
                            }
                        }
                    });
                    return false;
                }
            });
        }
    }

    public void collapse(boolean animated) {
        if (!this.isEnabled() || !this.expanded) {
            return;
        }
        this.pingIndicatorListeners(false);
        if (animated) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f * (float)this.getWidth(), 0.0f});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    HorizontalExpansionLayout.this.setWidth(((Float)valueAnimator.getAnimatedValue()).floatValue());
                }
            });
            valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    HorizontalExpansionLayout.this.animator = null;
                    HorizontalExpansionLayout.this.pingListeners();
                }
            });
            this.expanded = false;
            this.animator = valueAnimator;
            valueAnimator.start();
        } else {
            this.setWidth(0.0f);
            this.expanded = false;
            this.pingListeners();
        }
    }

    private void pingIndicatorListeners(boolean willBeExpanded) {
        for (IndicatorListener indicatorListener : this.indicatorListeners) {
            if (indicatorListener == null) continue;
            indicatorListener.onStartedExpand(this, willBeExpanded);
        }
    }

    private void pingListeners() {
        for (Listener listener : this.listeners) {
            if (listener == null) continue;
            listener.onExpansionChanged(this, this.expanded);
        }
    }

    public void expand(boolean animated) {
        if (!this.isEnabled() || this.expanded) {
            return;
        }
        this.pingIndicatorListeners(true);
        if (animated) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.getChildAt(0).getWidth()});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    HorizontalExpansionLayout.this.setWidth(((Float)valueAnimator.getAnimatedValue()).floatValue());
                }
            });
            valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    HorizontalExpansionLayout.this.animator = null;
                    HorizontalExpansionLayout.this.pingListeners();
                }
            });
            this.expanded = true;
            this.animator = valueAnimator;
            valueAnimator.start();
        } else {
            this.setWidth(this.getChildAt(0).getWidth());
            this.expanded = true;
            this.pingListeners();
        }
    }

    private void setWidth(float width) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.width = (int)width;
            this.setLayoutParams(layoutParams);
        }
    }

    public void toggle(boolean animated) {
        if (this.expanded) {
            this.collapse(animated);
        } else {
            this.expand(animated);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public static interface IndicatorListener {
        public void onStartedExpand(HorizontalExpansionLayout var1, boolean var2);
    }

    public static interface Listener {
        public void onExpansionChanged(HorizontalExpansionLayout var1, boolean var2);
    }
}

