/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.androidnosql.datasaver;

import android.content.Context;
import android.content.SharedPreferences;
import com.github.florent37.androidnosql.datasaver.DataSaver;
import java.util.HashSet;
import java.util.Set;

public class SharedPreferencesDataSaver
implements DataSaver {
    public static final String NODES = "%nodes%";
    public static final String NODES_SHARED_PREFS = "%nodes%";
    private final SharedPreferences sharedPreferences;

    public SharedPreferencesDataSaver(SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    public SharedPreferencesDataSaver(Context context) {
        this(context.getSharedPreferences("%nodes%", 0));
    }

    @Override
    public void saveNodes(String completePath, Set<String> values) {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add(completePath);
        nodes.addAll(this.getNodes());
        for (String value : values) {
            nodes.add(completePath + value);
        }
        this.sharedPreferences.edit().putStringSet("%nodes%", nodes).apply();
    }

    @Override
    public void saveValue(String completePath, Object value) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        if (value instanceof Integer) {
            editor.putInt(completePath, ((Integer)value).intValue());
        } else if (value instanceof Float) {
            editor.putFloat(completePath, ((Float)value).floatValue());
        } else if (value instanceof Boolean) {
            editor.putBoolean(completePath, ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            editor.putLong(completePath, ((Long)value).longValue());
        } else {
            editor.putString(completePath, String.valueOf(value));
        }
        editor.apply();
    }

    @Override
    public Set<String> getNodes() {
        return this.sharedPreferences.getStringSet("%nodes%", new HashSet());
    }

    @Override
    public Object getValue(String completePath) {
        return this.sharedPreferences.getAll().get(completePath);
    }

    @Override
    public void remove(String startingPath) {
        Set<String> nodes = this.getNodes();
        HashSet<String> nodesToKeep = new HashSet<String>();
        for (String node : nodes) {
            if (node.startsWith(startingPath)) {
                this.sharedPreferences.edit().remove(node).apply();
                continue;
            }
            nodesToKeep.add(node);
        }
        this.sharedPreferences.edit().putStringSet("%nodes%", nodesToKeep).apply();
    }
}

