/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.viewanimator;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import androidx.annotation.IntRange;
import com.github.florent37.viewanimator.AnimationBuilder;
import com.github.florent37.viewanimator.AnimationListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class ViewAnimator {
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;
    private static final long DEFAULT_DURATION = 3000L;
    private List<AnimationBuilder> animationList = new ArrayList<AnimationBuilder>();
    private long duration = 3000L;
    private long startDelay = 0L;
    private Interpolator interpolator = null;
    private int repeatCount = 0;
    private int repeatMode = 1;
    private AnimatorSet animatorSet;
    private View waitForThisViewHeight = null;
    private AnimationListener.Start startListener;
    private AnimationListener.Stop stopListener;
    private ViewAnimator prev = null;
    private ViewAnimator next = null;

    protected AnimatorSet createAnimatorSet() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        for (AnimationBuilder animationBuilder : this.animationList) {
            List<Animator> animatorList = animationBuilder.createAnimators();
            if (animationBuilder.getSingleInterpolator() != null) {
                for (Animator animator : animatorList) {
                    animator.setInterpolator((TimeInterpolator)animationBuilder.getSingleInterpolator());
                }
            }
            animators.addAll(animatorList);
        }
        for (AnimationBuilder animationBuilder : this.animationList) {
            if (!animationBuilder.isWaitForHeight()) continue;
            this.waitForThisViewHeight = animationBuilder.getView();
            break;
        }
        for (Animator animator : animators) {
            if (!(animator instanceof ValueAnimator)) continue;
            ValueAnimator valueAnimator = (ValueAnimator)animator;
            valueAnimator.setRepeatCount(this.repeatCount);
            valueAnimator.setRepeatMode(this.repeatMode);
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(animators);
        animatorSet.setDuration(this.duration);
        animatorSet.setStartDelay(this.startDelay);
        if (this.interpolator != null) {
            animatorSet.setInterpolator((TimeInterpolator)this.interpolator);
        }
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (ViewAnimator.this.startListener != null) {
                    ViewAnimator.this.startListener.onStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (ViewAnimator.this.stopListener != null) {
                    ViewAnimator.this.stopListener.onStop();
                }
                if (ViewAnimator.this.next != null) {
                    ViewAnimator.this.next.prev = null;
                    ViewAnimator.this.next.start();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        return animatorSet;
    }

    public static AnimationBuilder animate(View ... view) {
        ViewAnimator viewAnimator = new ViewAnimator();
        return viewAnimator.addAnimationBuilder(view);
    }

    public AnimationBuilder thenAnimate(View ... views) {
        ViewAnimator nextViewAnimator;
        this.next = nextViewAnimator = new ViewAnimator();
        nextViewAnimator.prev = this;
        return nextViewAnimator.addAnimationBuilder(views);
    }

    public AnimationBuilder addAnimationBuilder(View ... views) {
        AnimationBuilder animationBuilder = new AnimationBuilder(this, views);
        this.animationList.add(animationBuilder);
        return animationBuilder;
    }

    public ViewAnimator repeatCount(@IntRange(from=-1L) int repeatCount) {
        this.repeatCount = repeatCount;
        return this;
    }

    public void start() {
        if (this.prev != null) {
            this.prev.start();
        } else {
            this.animatorSet = this.createAnimatorSet();
            if (this.waitForThisViewHeight != null) {
                this.waitForThisViewHeight.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        ViewAnimator.this.animatorSet.start();
                        ViewAnimator.this.waitForThisViewHeight.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        return false;
                    }
                });
            } else {
                this.animatorSet.start();
            }
        }
    }

    public void cancel() {
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        if (this.next != null) {
            this.next.cancel();
            this.next = null;
        }
    }

    public ViewAnimator duration(@IntRange(from=1L) long duration) {
        this.duration = duration;
        return this;
    }

    public ViewAnimator startDelay(@IntRange(from=0L) long startDelay) {
        this.startDelay = startDelay;
        return this;
    }

    public ViewAnimator repeatMode(int repeatMode) {
        this.repeatMode = repeatMode;
        return this;
    }

    public ViewAnimator onStart(AnimationListener.Start startListener) {
        this.startListener = startListener;
        return this;
    }

    public ViewAnimator onStop(AnimationListener.Stop stopListener) {
        this.stopListener = stopListener;
        return this;
    }

    public ViewAnimator interpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RepeatMode {
    }
}

