/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.legacy.content.WakefulBroadcastReceiver;
import com.flarelane.BaseErrorHandler;
import com.flarelane.FlareLane;
import com.flarelane.Helper;
import com.flarelane.Logger;
import com.flarelane.Notification;
import com.flarelane.NotificationReceivedEvent;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class FCMBroadcastReceiver
extends WakefulBroadcastReceiver {
    public void onReceive(final Context context, final Intent intent) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FCMBroadcastReceiver.this.showNotification(context, intent);
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
            }
        }).start();
    }

    private void showNotification(Context context, Intent intent) throws Exception {
        boolean dismissForegroundNotification;
        if (intent == null || intent.getExtras() == null) {
            Logger.error("intent is NULL");
            return;
        }
        JSONObject jsonObject = this.bundleAsJSONObject(intent.getExtras());
        String isFlareLane = jsonObject.optString("isFlareLane");
        if (!isFlareLane.contentEquals("true")) {
            Logger.verbose("It is not a message of FlareLane");
            return;
        }
        Notification flarelaneNotification = new Notification(jsonObject);
        Logger.verbose("Message data payload: " + flarelaneNotification);
        boolean isForeground = Helper.appInForeground(context);
        Logger.verbose("onMessageReceived isForeground: " + isForeground);
        JSONObject data = flarelaneNotification.getDataJsonObject();
        boolean bl = dismissForegroundNotification = data != null && data.optString("flarelane_dismiss_foreground_notification").equals("true");
        if (isForeground && dismissForegroundNotification) {
            Logger.verbose("notification dismissed cause flarelane_dismiss_foreground_notification is true.");
            return;
        }
        NotificationReceivedEvent event = new NotificationReceivedEvent(context.getApplicationContext(), flarelaneNotification);
        if (isForeground && FlareLane.notificationForegroundReceivedHandler != null) {
            Logger.verbose("notificationForegroundReceivedHandler exists, you can control the display timing.");
            FlareLane.notificationForegroundReceivedHandler.onWillDisplay(event);
            return;
        }
        event.display();
    }

    private JSONObject bundleAsJSONObject(Bundle bundle) {
        JSONObject json = new JSONObject();
        Set keys = bundle.keySet();
        for (String key : keys) {
            try {
                json.put(key, bundle.get(key));
            }
            catch (JSONException e) {
                Logger.error(Log.getStackTraceString((Throwable)e));
            }
        }
        return json;
    }
}

