/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.content.Context;
import android.os.Build;
import androidx.annotation.Nullable;
import com.flarelane.BaseErrorHandler;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.Device;
import com.flarelane.FlareLane;
import com.flarelane.HTTPClient;
import com.flarelane.Helper;
import com.flarelane.Logger;
import com.flarelane.Utils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONObject;

class DeviceService {
    DeviceService() {
    }

    static JSONObject getSystemInfo(Context context) throws Exception {
        JSONObject data = new JSONObject();
        data.put("platform", (Object)"android");
        data.put("deviceModel", (Object)Build.MODEL);
        data.put("osVersion", (Object)String.valueOf(Build.VERSION.RELEASE));
        data.put("appVersion", (Object)Helper.getValidSemVerAppVersion(context));
        data.put("sdkVersion", (Object)FlareLane.SdkInfo.version);
        data.put("timeZone", (Object)TimeZone.getDefault().getID());
        data.put("languageCode", (Object)Locale.getDefault().getLanguage());
        data.put("countryCode", (Object)Locale.getDefault().getCountry());
        data.put("sdkType", (Object)FlareLane.SdkInfo.type.toString());
        return data;
    }

    static void register(final Context context, String projectId, final @Nullable ResponseHandler responseHandler) {
        try {
            JSONObject data = DeviceService.getSystemInfo(context);
            DeviceService.create(projectId, data, new ResponseHandler(){

                @Override
                public void onSuccess(Device device) {
                    BaseSharedPreferences.setDeviceId(context, device.id);
                    Logger.verbose("deviceId : " + device.id);
                    if (responseHandler != null) {
                        responseHandler.onSuccess(device);
                    }
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    static void activate(Context context, final @Nullable ResponseHandler responseHandler) {
        try {
            JSONObject data = DeviceService.getSystemInfo(context);
            data.put("lastActiveAt", (Object)Utils.getISO8601DateString());
            DeviceService.update(context, data, new ResponseHandler(){

                @Override
                public void onSuccess(Device device) {
                    if (responseHandler != null) {
                        responseHandler.onSuccess(device);
                    }
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    static void create(String projectId, JSONObject data, final @Nullable ResponseHandler handler) {
        HTTPClient.post("internal/v1/projects/" + projectId + "/devices", data, new HTTPClient.ResponseHandler(){

            @Override
            void onSuccess(int responseCode, JSONObject response) {
                super.onSuccess(responseCode, response);
                try {
                    JSONObject data = response.getJSONObject("data");
                    Device device = new Device(data.getString("id"), data.getBoolean("isSubscribed"), null);
                    if (handler != null) {
                        handler.onSuccess(device);
                    }
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
            }
        });
    }

    static void update(final Context context, JSONObject data, final @Nullable ResponseHandler handler) throws Exception {
        String projectId = BaseSharedPreferences.getProjectId(context, false);
        String deviceId = BaseSharedPreferences.getDeviceId(context, false);
        HTTPClient.patch("internal/v1/projects/" + projectId + "/devices/" + deviceId, data, new HTTPClient.ResponseHandler(){

            @Override
            void onSuccess(int responseCode, JSONObject response) {
                super.onSuccess(responseCode, response);
                try {
                    JSONObject responseData = response.getJSONObject("data");
                    Device device = new Device(responseData.getString("id"), responseData.getBoolean("isSubscribed"), responseData.isNull("userId") ? null : responseData.getString("userId"));
                    BaseSharedPreferences.setUserId(context, device.userId);
                    BaseSharedPreferences.setIsSubscribed(context, device.isSubscribed);
                    if (handler != null) {
                        handler.onSuccess(device);
                    }
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
            }
        });
    }

    private static String getAdvertisingId(Context context) {
        try {
            AdvertisingIdClient.Info advertisingIdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
            if (!advertisingIdInfo.isLimitAdTrackingEnabled()) {
                String id2 = advertisingIdInfo.getId();
                return id2;
            }
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
        return null;
    }

    protected static interface TagsResponseHandler {
        public void onSuccess(JSONObject var1);
    }

    protected static interface ResponseHandler {
        public void onSuccess(Device var1);
    }
}

