/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.annotation.SuppressLint;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import com.flarelane.BaseErrorHandler;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.EventService;
import com.flarelane.FlareLane;
import com.flarelane.Helper;
import com.flarelane.Notification;
import com.flarelane.NotificationClickedActivity;
import com.flarelane.util.ExtensionsKt;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;

public class NotificationReceivedEvent {
    private Context context;
    private Notification notification;

    public NotificationReceivedEvent(Context context, Notification notification) {
        this.context = context;
        this.notification = notification;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public void display() {
        try {
            final Notification flarelaneNotification = this.getNotification();
            final String projectId = BaseSharedPreferences.getProjectId(this.context, false);
            final String deviceId = BaseSharedPreferences.getDeviceId(this.context, false);
            final String userId = BaseSharedPreferences.getUserId(this.context, true);
            final boolean isForeground = Helper.appInForeground(this.context);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Intent clickedIntent = new Intent(NotificationReceivedEvent.this.context, NotificationClickedActivity.class).addFlags(0x24000000);
                        ExtensionsKt.putParcelableDataClass(clickedIntent, NotificationReceivedEvent.this.notification);
                        PendingIntent contentIntent = PendingIntent.getActivity((Context)NotificationReceivedEvent.this.context, (int)new Random().nextInt(543254), (Intent)clickedIntent, (int)0x4000000);
                        int currentIcon = ((NotificationReceivedEvent)NotificationReceivedEvent.this).context.getPackageManager().getApplicationInfo((String)((NotificationReceivedEvent)NotificationReceivedEvent.this).context.getPackageName(), (int)128).icon;
                        Bitmap image = null;
                        if (flarelaneNotification.imageUrl != null) {
                            try {
                                URL url = new URL(flarelaneNotification.imageUrl);
                                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                                connection.setDoInput(true);
                                connection.connect();
                                InputStream in = connection.getInputStream();
                                image = BitmapFactory.decodeStream((InputStream)in);
                            }
                            catch (Exception e) {
                                BaseErrorHandler.handle(e);
                            }
                        }
                        NotificationCompat.Builder builder = new NotificationCompat.Builder(NotificationReceivedEvent.this.context, flarelaneNotification.currentChannelId(NotificationReceivedEvent.this.context)).setSmallIcon(NotificationReceivedEvent.this.getNotificationIcon(NotificationReceivedEvent.this.context)).setContentText((CharSequence)flarelaneNotification.body).setContentTitle((CharSequence)(flarelaneNotification.title == null ? NotificationReceivedEvent.this.context.getApplicationInfo().loadLabel(NotificationReceivedEvent.this.context.getPackageManager()).toString() : flarelaneNotification.title)).setAutoCancel(true).setContentIntent(contentIntent).setPriority(2).setVisibility(1);
                        try {
                            String accentColor = Helper.getResourceString(NotificationReceivedEvent.this.context.getApplicationContext(), "flarelane_notification_accent_color");
                            if (accentColor != null) {
                                builder = builder.setColor(Color.parseColor((String)accentColor));
                            }
                        }
                        catch (Exception e) {
                            BaseErrorHandler.handle(e);
                        }
                        builder = image != null ? builder.setLargeIcon(image).setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(image).bigLargeIcon(null).setSummaryText((CharSequence)flarelaneNotification.body)) : builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)flarelaneNotification.body));
                        android.app.Notification notification = builder.build();
                        notification.defaults |= 1;
                        notification.defaults |= 4;
                        notification.defaults |= 2;
                        NotificationManager notificationManager = (NotificationManager)NotificationReceivedEvent.this.context.getSystemService("notification");
                        notificationManager.notify(flarelaneNotification.currentAndroidNotificationId(), notification);
                        if (isForeground) {
                            EventService.createForegroundReceived(projectId, deviceId, flarelaneNotification, userId);
                        } else {
                            EventService.createBackgroundReceived(projectId, deviceId, flarelaneNotification, userId);
                        }
                    }
                    catch (Exception e) {
                        BaseErrorHandler.handle(e);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    @SuppressLint(value={"DiscouragedApi"})
    private int getNotificationIcon(Context context) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                if (FlareLane.notificationIcon != 0) {
                    return FlareLane.notificationIcon;
                }
                int getDefaultIconId = context.getResources().getIdentifier("ic_stat_flarelane_default", "drawable", context.getPackageName());
                if (getDefaultIconId != 0) {
                    return getDefaultIconId;
                }
            }
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
        return 17301569;
    }
}

