/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.flarelane.Helper;
import com.flarelane.R;

class ChannelManager {
    private static final String DEFAULT_CHANNEL_ID = "com.flarelane.default_notification_channel_id";

    ChannelManager() {
    }

    protected static String getDefaultChannelId(Context context) {
        String customChannelId = ChannelManager.getCustomChannelId(context);
        return customChannelId != null ? customChannelId : DEFAULT_CHANNEL_ID;
    }

    protected static String getCustomChannelId(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            return appInfo.metaData.getString("flarelane_default_channel_id");
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    protected static String getDefaultChannelName(Context context) {
        String customChannelName = Helper.getResourceString(context.getApplicationContext(), "flarelane_default_channel_name");
        return customChannelName != null ? customChannelName : context.getString(R.string.default_notification_channel_name);
    }

    protected static void createNotificationChannel(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            if (ChannelManager.getCustomChannelId(context) != null) {
                return;
            }
            NotificationChannel channel = new NotificationChannel(ChannelManager.getDefaultChannelId(context), (CharSequence)ChannelManager.getDefaultChannelName(context), 4);
            channel.setShowBadge(true);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.createNotificationChannel(channel);
        }
    }
}

