/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.flarelane.FlareLane;
import com.flarelane.NotificationClickedActivity;
import com.flarelane.PermissionActivity;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ActivityLifecycleManager {
    private final Set<Activity> activitySet = new HashSet<Activity>();
    private final List<Class<?>> skipActivityList = Arrays.asList(PermissionActivity.class, NotificationClickedActivity.class);
    protected Application.ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
            if (ActivityLifecycleManager.this.isSkipActivity(activity)) {
                return;
            }
            ActivityLifecycleManager.this.activitySet.add(activity);
            FlareLane.deviceRegisterOrActivate(activity.getApplicationContext(), null);
        }

        public void onActivityResumed(@NonNull Activity activity) {
        }

        public void onActivityPaused(@NonNull Activity activity) {
        }

        public void onActivityStopped(@NonNull Activity activity) {
            if (ActivityLifecycleManager.this.isSkipActivity(activity)) {
                return;
            }
            ActivityLifecycleManager.this.activitySet.remove(activity);
            if (ActivityLifecycleManager.this.activitySet.isEmpty()) {
                FlareLane.isActivated = false;
            }
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        }
    };

    ActivityLifecycleManager() {
    }

    private boolean isSkipActivity(Activity activity) {
        return this.skipActivityList.contains(activity.getClass());
    }
}

