/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.os.Handler;
import android.os.Looper;
import com.flarelane.Logger;
import com.flarelane.NamedRunnable;
import java.util.LinkedList;
import java.util.Queue;

class TaskQueueManager {
    private static final long TIMEOUT_MS = 10000L;
    private final Queue<NamedRunnable> taskQueue = new LinkedList<NamedRunnable>();
    private boolean isProcessing = false;
    private boolean isInitialized = false;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private Runnable timeoutRunnable;
    private static TaskQueueManager instance;

    private TaskQueueManager() {
    }

    public static synchronized TaskQueueManager getInstance() {
        if (instance == null) {
            instance = new TaskQueueManager();
        }
        return instance;
    }

    public synchronized void addTask(NamedRunnable task) {
        this.taskQueue.add(task);
        Logger.verbose("Task added to queue: " + task.getTaskName() + ". Queue size after adding: " + this.taskQueue.size());
        if (this.isInitialized && !this.isProcessing) {
            this.processNext();
        }
    }

    private synchronized void executeTask(NamedRunnable task) {
        if (this.isProcessing) {
            return;
        }
        this.isProcessing = true;
        Logger.verbose("Executing task: " + task.getTaskName() + ". Queue size before execution: " + this.taskQueue.size());
        this.timeoutRunnable = () -> {
            TaskQueueManager taskQueueManager = this;
            synchronized (taskQueueManager) {
                if (this.isProcessing) {
                    Logger.verbose("Task timed out: " + task.getTaskName() + ". Processing next task.");
                    this.completeTask();
                }
            }
        };
        this.handler.postDelayed(this.timeoutRunnable, 10000L);
        task.setTaskCompleteCallback(this::completeTask);
        new Thread(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                Logger.error("Error executing task: " + task.getTaskName());
                this.completeTask();
            }
        }).start();
    }

    private synchronized void processNext() {
        if (this.taskQueue.isEmpty()) {
            this.isProcessing = false;
            Logger.verbose("No more tasks in queue. Queue is empty.");
            return;
        }
        NamedRunnable nextTask = this.taskQueue.poll();
        Logger.verbose("Processing next task: " + nextTask.getTaskName() + ". Queue size before processing: " + this.taskQueue.size());
        this.executeTask(nextTask);
    }

    private synchronized void completeTask() {
        if (this.timeoutRunnable != null) {
            this.handler.removeCallbacks(this.timeoutRunnable);
            this.timeoutRunnable = null;
        }
        this.isProcessing = false;
        Logger.verbose("Task completed. Queue size after completion: " + this.taskQueue.size());
        this.processNext();
    }

    public synchronized void onInitialized() {
        this.isInitialized = true;
        Logger.verbose("Task queue initialized. Processing queued tasks.");
        if (!this.isProcessing) {
            this.processNext();
        }
    }
}

