/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.flarelane.ActivityLifecycleManager;
import com.flarelane.BaseErrorHandler;
import com.flarelane.BaseSharedPreferences;
import com.flarelane.ChannelManager;
import com.flarelane.Device;
import com.flarelane.DeviceService;
import com.flarelane.EventService;
import com.flarelane.FirebaseManager;
import com.flarelane.Helper;
import com.flarelane.Logger;
import com.flarelane.NotificationClickedHandler;
import com.flarelane.NotificationForegroundReceivedHandler;
import com.flarelane.PermissionActivity;
import com.flarelane.RemoteParams;
import com.flarelane.RemoteParamsManager;
import com.flarelane.SdkType;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import org.json.JSONObject;

public class FlareLane {
    protected static NotificationForegroundReceivedHandler notificationForegroundReceivedHandler = null;
    protected static NotificationClickedHandler notificationClickedHandler = null;
    protected static int notificationIcon = 0;
    protected static boolean requestPermissionOnLaunch = false;
    private static Handler mainHandler = new Handler(Looper.getMainLooper());
    protected static boolean isActivated = false;
    private static ActivityLifecycleManager activityLifecycleManager = new ActivityLifecycleManager();

    public static void initWithContext(Context context, String projectId, boolean requestPermissionOnLaunch) {
        try {
            FlareLane.requestPermissionOnLaunch = requestPermissionOnLaunch;
            Logger.verbose("initWithContext projectId: " + projectId);
            ChannelManager.createNotificationChannel(context);
            String savedProjectId = BaseSharedPreferences.getProjectId(context, true);
            if (savedProjectId == null || !savedProjectId.contentEquals(projectId)) {
                BaseSharedPreferences.setDeviceId(context, null);
                BaseSharedPreferences.setIsSubscribed(context, false);
                BaseSharedPreferences.setProjectId(context, projectId);
            }
            FlareLane.deviceRegisterOrActivate(context);
            Application application = (Application)context.getApplicationContext();
            application.registerActivityLifecycleCallbacks(FlareLane.activityLifecycleManager.mActivityLifecycleCallbacks);
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void setNotificationIcon(int notificationIcon) {
        FlareLane.notificationIcon = notificationIcon;
    }

    public static void setLogLevel(int logLevel) {
        try {
            Logger.logLevel = logLevel;
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void setNotificationClickedHandler(NotificationClickedHandler handler) {
        try {
            notificationClickedHandler = handler;
            if (EventService.unhandledClickedNotification != null) {
                handler.onClicked(EventService.unhandledClickedNotification);
                EventService.unhandledClickedNotification = null;
            }
            Logger.verbose("NotificationClickedHandler has been registered.");
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void setNotificationForegroundReceivedHandler(NotificationForegroundReceivedHandler notificationForegroundReceivedHandler) {
        try {
            FlareLane.notificationForegroundReceivedHandler = notificationForegroundReceivedHandler;
            Logger.verbose("NotificationForegroundReceivedHandler has been registered.");
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void setUserId(final Context context, String userId) {
        try {
            JSONObject data = new JSONObject();
            data.put("userId", userId == null ? JSONObject.NULL : userId);
            DeviceService.update(context, data, new DeviceService.ResponseHandler(){

                @Override
                public void onSuccess(Device device) {
                    BaseSharedPreferences.setUserId(context, device.userId);
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void setTags(Context context, JSONObject tags) {
        try {
            JSONObject data = new JSONObject();
            data.put("tags", (Object)tags);
            DeviceService.update(context, data, new DeviceService.ResponseHandler(){

                @Override
                public void onSuccess(Device device) {
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static String getDeviceId(Context context) {
        try {
            String deviceId = BaseSharedPreferences.getDeviceId(context, true);
            return deviceId;
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
            return null;
        }
    }

    public static boolean isSubscribed(Context context) {
        try {
            boolean hasPermission = Build.VERSION.SDK_INT < 33 || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.POST_NOTIFICATIONS") == 0;
            String savedIsSubscribed = BaseSharedPreferences.getIsSubscribed(context, true);
            return hasPermission && savedIsSubscribed != null && savedIsSubscribed.contentEquals("true");
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
            return false;
        }
    }

    public static void subscribe(final Context context, boolean fallbackToSettings, @Nullable IsSubscribedHandler handler) {
        try {
            PermissionActivity.isSubscribedHandler = handler;
            if (Build.VERSION.SDK_INT >= 33 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.POST_NOTIFICATIONS") != 0) {
                Application application = (Application)context.getApplicationContext();
                int targetSdkVersion = application.getApplicationInfo().targetSdkVersion;
                if (targetSdkVersion < 33 || fallbackToSettings && BaseSharedPreferences.getAlreadyPermissionAsked(context)) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Intent intent = new Intent();
                            intent.setAction("android.settings.APP_NOTIFICATION_SETTINGS");
                            intent.addFlags(0x10000000);
                            intent.putExtra("android.provider.extra.APP_PACKAGE", context.getPackageName());
                            context.startActivity(intent);
                        }
                    }).start();
                } else {
                    FlareLane.requestPermissionForNotifications(context, handler);
                }
            } else {
                FlareLane.subscribeWithPushToken(context, handler);
            }
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void unsubscribe(Context context, final @Nullable IsSubscribedHandler handler) {
        try {
            JSONObject data = new JSONObject();
            data.put("isSubscribed", false);
            DeviceService.update(context, data, new DeviceService.ResponseHandler(){

                @Override
                public void onSuccess(final Device device) {
                    if (handler != null) {
                        mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                handler.onSuccess(device.isSubscribed);
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    public static void trackEvent(Context context, String type, JSONObject data) {
        try {
            String projectId = BaseSharedPreferences.getProjectId(context, false);
            String deviceId = BaseSharedPreferences.getDeviceId(context, false);
            String userId = BaseSharedPreferences.getUserId(context, true);
            String subjectType = userId != null ? "user" : "device";
            String subjectId = userId != null ? userId : deviceId;
            EventService.trackEvent(projectId, subjectType, subjectId, type, data);
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    protected static void requestPermissionForNotifications(Context context, @Nullable IsSubscribedHandler handler) {
        Application application = (Application)context.getApplicationContext();
        int targetSdkVersion = application.getApplicationInfo().targetSdkVersion;
        if (Build.VERSION.SDK_INT >= 33 && targetSdkVersion >= 33 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.POST_NOTIFICATIONS") != 0) {
            Intent intent = new Intent(context, PermissionActivity.class);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        } else {
            FlareLane.subscribeWithPushToken(context, handler);
        }
    }

    protected static void deviceRegisterOrActivate(final Context context) {
        try {
            String projectId = BaseSharedPreferences.getProjectId(context, true);
            if (projectId == null || projectId.trim().isEmpty()) {
                return;
            }
            if (!Helper.appInForeground(context) || isActivated) {
                return;
            }
            isActivated = true;
            String savedDeviceId = BaseSharedPreferences.getDeviceId(context, true);
            if (savedDeviceId == null || savedDeviceId.trim().isEmpty()) {
                Logger.verbose("savedDeviceId is not exists, newly registered");
                DeviceService.register(context, projectId, new DeviceService.ResponseHandler(){

                    @Override
                    public void onSuccess(Device device) {
                        if (!FlareLane.isSubscribed(context) && requestPermissionOnLaunch && Helper.appInForeground(context)) {
                            FlareLane.requestPermissionForNotifications(context, null);
                        }
                    }
                });
            } else {
                Logger.verbose("savedDeviceId is exists : " + savedDeviceId);
                DeviceService.activate(context, new DeviceService.ResponseHandler(){

                    @Override
                    public void onSuccess(Device device) {
                        if (!FlareLane.isSubscribed(context) && requestPermissionOnLaunch && Helper.appInForeground(context)) {
                            FlareLane.requestPermissionForNotifications(context, null);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    protected static void subscribeWithPushToken(final Context context, final @Nullable IsSubscribedHandler handler) {
        try {
            FlareLane.getPushToken(context, new GetPushTokenHandler(){

                @Override
                public void onSuccess(String pushToken) {
                    try {
                        JSONObject data = new JSONObject();
                        data.put("isSubscribed", true);
                        data.put("pushToken", (Object)pushToken);
                        DeviceService.update(context, data, new DeviceService.ResponseHandler(){

                            @Override
                            public void onSuccess(final Device device) {
                                if (handler != null) {
                                    mainHandler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            handler.onSuccess(device.isSubscribed);
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        BaseErrorHandler.handle(e);
                    }
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    private static void getPushToken(final Context context, final @Nullable GetPushTokenHandler handler) {
        try {
            String projectId = BaseSharedPreferences.getProjectId(context, false);
            if (Build.VERSION.SDK_INT >= 33 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.POST_NOTIFICATIONS") != 0) {
                Logger.verbose("updatePushToken failed: Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU, but POST_NOTIFICATIONS is not granted!");
                return;
            }
            RemoteParamsManager.fetchRemoteParams(projectId, new RemoteParamsManager.ResponseHandler(){

                @Override
                public void onSuccess(RemoteParams remoteParams) {
                    try {
                        if (remoteParams.fcmSenderId == null) {
                            Logger.error("senderId is null. Please check a property of your project");
                            return;
                        }
                        Task getTokenTask = FirebaseManager.getFirebaseMessaging(context, remoteParams).getToken();
                        getTokenTask.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

                            public void onComplete(@NonNull Task<String> task) {
                                try {
                                    if (!task.isSuccessful()) {
                                        Logger.error("Fetching FCM registration token failed: " + task.getException());
                                        return;
                                    }
                                    String token = (String)task.getResult();
                                    if (token == null) {
                                        Logger.error("token is null");
                                        return;
                                    }
                                    if (handler != null) {
                                        handler.onSuccess(token);
                                    }
                                }
                                catch (Exception e) {
                                    BaseErrorHandler.handle(e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        BaseErrorHandler.handle(e);
                    }
                }
            });
        }
        catch (Exception e) {
            BaseErrorHandler.handle(e);
        }
    }

    protected static interface GetPushTokenHandler {
        public void onSuccess(String var1);
    }

    public static interface IsSubscribedHandler {
        public void onSuccess(boolean var1);
    }

    public static class SdkInfo {
        public static SdkType type = SdkType.NATIVE;
        public static String version = "1.6.2";
    }
}

