/*
 * Decompiled with CFR 0.152.
 */
package com.flarelane;

import com.flarelane.BaseErrorHandler;
import com.flarelane.HTTPClient;
import com.flarelane.Logger;
import com.flarelane.RemoteParams;
import org.json.JSONObject;

class RemoteParamsManager {
    static RemoteParams remoteParams;

    RemoteParamsManager() {
    }

    static void fetchRemoteParams(String projectId, final ResponseHandler handler) {
        if (remoteParams != null) {
            return;
        }
        HTTPClient.get("internal/v1/projects/" + projectId + "/remote-params", new HTTPClient.ResponseHandler(){

            @Override
            void onSuccess(int responseCode, JSONObject response) {
                super.onSuccess(responseCode, response);
                try {
                    Logger.verbose("fetchRemoteParams Success: " + response.toString());
                    JSONObject data = response.getJSONObject("data");
                    String senderId = data.isNull("fcmSenderId") ? null : data.getString("fcmSenderId");
                    remoteParams = new RemoteParams(senderId);
                    handler.onSuccess(remoteParams);
                }
                catch (Exception e) {
                    BaseErrorHandler.handle(e);
                }
            }
        });
    }

    protected static interface ResponseHandler {
        public void onSuccess(RemoteParams var1);
    }
}

