package com.glide.slider.library.transformers;

import android.view.View;

public class ZoomOutTransformer extends BaseTransformer {

    @Override
    protected void onTransform(View view, float position) {
        final float scale = 1f + Math.abs(position);
        view.setScaleX(scale);
        view.setScaleY(scale);
        view.setPivotX(view.getWidth() * 0.5f);
        view.setPivotY(view.getWidth() * 0.5f);
        view.setAlpha(position < -1f || position > 1f ? 0f : 1f - (scale - 1f));
        if (position < -0.9) {
            //-0.9 to prevent a small bug
            view.setTranslationX(view.getWidth() * position);
        }
    }
}