/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint.info_providers;

import android.content.ContentResolver;
import android.os.Build;
import android.provider.Settings;
import com.fingerprintjs.android.fingerprint.info_providers.SettingsDataSource;
import com.fingerprintjs.android.fingerprint.tools.threading.safe.SafeKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u0006H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/fingerprintjs/android/fingerprint/info_providers/SettingsDataSourceImpl;", "Lcom/fingerprintjs/android/fingerprint/info_providers/SettingsDataSource;", "contentResolver", "Landroid/content/ContentResolver;", "(Landroid/content/ContentResolver;)V", "accessibilityEnabled", "", "adbEnabled", "alarmAlertPath", "dataRoamingEnabled", "dateFormat", "defaultInputMethod", "developmentSettingsEnabled", "endButtonBehaviour", "extractGlobalSettingsParam", "key", "extractSecureSettingsParam", "extractSystemSettingsParam", "fontScale", "httpProxy", "rttCallingMode", "screenOffTimeout", "textAutoPunctuate", "textAutoReplaceEnable", "time12Or24", "touchExplorationEnabled", "transitionAnimationScale", "windowAnimationScale", "fingerprint_release"})
public final class SettingsDataSourceImpl
implements SettingsDataSource {
    @Nullable
    private final ContentResolver contentResolver;

    public SettingsDataSourceImpl(@Nullable ContentResolver contentResolver) {
        this.contentResolver = contentResolver;
    }

    @Override
    @NotNull
    public String adbEnabled() {
        return this.extractGlobalSettingsParam("adb_enabled");
    }

    @Override
    @NotNull
    public String developmentSettingsEnabled() {
        return this.extractGlobalSettingsParam("development_settings_enabled");
    }

    @Override
    @NotNull
    public String httpProxy() {
        return this.extractGlobalSettingsParam("http_proxy");
    }

    @Override
    @NotNull
    public String transitionAnimationScale() {
        return this.extractGlobalSettingsParam("transition_animation_scale");
    }

    @Override
    @NotNull
    public String windowAnimationScale() {
        return this.extractGlobalSettingsParam("window_animation_scale");
    }

    @Override
    @NotNull
    public String dataRoamingEnabled() {
        return this.extractGlobalSettingsParam("data_roaming");
    }

    @Override
    @NotNull
    public String accessibilityEnabled() {
        return this.extractSecureSettingsParam("accessibility_enabled");
    }

    @Override
    @NotNull
    public String defaultInputMethod() {
        return this.extractSecureSettingsParam("default_input_method");
    }

    @Override
    @NotNull
    public String rttCallingMode() {
        return Build.VERSION.SDK_INT >= 28 ? this.extractSecureSettingsParam("rtt_calling_mode") : "";
    }

    @Override
    @NotNull
    public String touchExplorationEnabled() {
        return this.extractSecureSettingsParam("touch_exploration_enabled");
    }

    @Override
    @NotNull
    public String alarmAlertPath() {
        return this.extractSystemSettingsParam("alarm_alert");
    }

    @Override
    @NotNull
    public String dateFormat() {
        return this.extractSystemSettingsParam("date_format");
    }

    @Override
    @NotNull
    public String endButtonBehaviour() {
        return this.extractSystemSettingsParam("end_button_behavior");
    }

    @Override
    @NotNull
    public String fontScale() {
        return this.extractSystemSettingsParam("font_scale");
    }

    @Override
    @NotNull
    public String screenOffTimeout() {
        return this.extractSystemSettingsParam("screen_off_timeout");
    }

    @Override
    @NotNull
    public String textAutoReplaceEnable() {
        return this.extractSystemSettingsParam("auto_replace");
    }

    @Override
    @NotNull
    public String textAutoPunctuate() {
        return this.extractSystemSettingsParam("auto_punctuate");
    }

    @Override
    @NotNull
    public String time12Or24() {
        return this.extractSystemSettingsParam("time_12_24");
    }

    private final String extractGlobalSettingsParam(String key) {
        Object object = SafeKt.safeWithTimeout$default(0L, (Function0)new Function0<String>(this, key){
            final /* synthetic */ SettingsDataSourceImpl this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(0);
            }

            @NotNull
            public final String invoke() {
                ContentResolver contentResolver = SettingsDataSourceImpl.access$getContentResolver$p(this.this$0);
                Intrinsics.checkNotNull((Object)contentResolver);
                String string = Settings.Global.getString((ContentResolver)contentResolver, (String)this.$key);
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
        }, 1, null);
        String string = "";
        return (String)(Result.isFailure-impl((Object)object) ? string : object);
    }

    private final String extractSecureSettingsParam(String key) {
        Object object = SafeKt.safeWithTimeout$default(0L, (Function0)new Function0<String>(this, key){
            final /* synthetic */ SettingsDataSourceImpl this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(0);
            }

            @NotNull
            public final String invoke() {
                ContentResolver contentResolver = SettingsDataSourceImpl.access$getContentResolver$p(this.this$0);
                Intrinsics.checkNotNull((Object)contentResolver);
                String string = Settings.Secure.getString((ContentResolver)contentResolver, (String)this.$key);
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
        }, 1, null);
        String string = "";
        return (String)(Result.isFailure-impl((Object)object) ? string : object);
    }

    private final String extractSystemSettingsParam(String key) {
        Object object = SafeKt.safeWithTimeout$default(0L, (Function0)new Function0<String>(this, key){
            final /* synthetic */ SettingsDataSourceImpl this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(0);
            }

            @NotNull
            public final String invoke() {
                ContentResolver contentResolver = SettingsDataSourceImpl.access$getContentResolver$p(this.this$0);
                Intrinsics.checkNotNull((Object)contentResolver);
                String string = Settings.System.getString((ContentResolver)contentResolver, (String)this.$key);
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
        }, 1, null);
        String string = "";
        return (String)(Result.isFailure-impl((Object)object) ? string : object);
    }

    public static final /* synthetic */ ContentResolver access$getContentResolver$p(SettingsDataSourceImpl $this) {
        return $this.contentResolver;
    }
}

