/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint;

import androidx.annotation.WorkerThread;
import com.fingerprintjs.android.fingerprint.Configuration;
import com.fingerprintjs.android.fingerprint.DeviceIdResult;
import com.fingerprintjs.android.fingerprint.FingerprintResult;
import com.fingerprintjs.android.fingerprint.Fingerprinter;
import com.fingerprintjs.android.fingerprint.device_id_signals.DeviceIdSignalsProvider;
import com.fingerprintjs.android.fingerprint.fingerprinting_signals.FingerprintingSignal;
import com.fingerprintjs.android.fingerprint.fingerprinting_signals.FingerprintingSignalsProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.SignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.StabilityLevel;
import com.fingerprintjs.android.fingerprint.signal_providers.device_id.DeviceIdProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.device_state.DeviceStateSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.hardware.HardwareSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.installed_apps.InstalledAppsSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.os_build.OsBuildSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.tools.FingerprintingLegacySchemeSupportExtensions;
import com.fingerprintjs.android.fingerprint.tools.hashers.Hasher;
import com.fingerprintjs.android.fingerprint.tools.hashers.MurMur3x64x128Hasher;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002 !B!\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u0012H\u0007J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u0012J8\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00100\u0012H\u0007J&\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u0012H\u0007J$\u0010\u0015\u001a\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u0006\u0010\u001e\u001a\u00020\u0005J\u001e\u0010\u001f\u001a\u00020\u001a*\u00020\u00192\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/fingerprintjs/android/fingerprint/Fingerprinter;", "", "legacyArgs", "Lcom/fingerprintjs/android/fingerprint/Fingerprinter$LegacyArgs;", "fpSignalsProvider", "Lcom/fingerprintjs/android/fingerprint/fingerprinting_signals/FingerprintingSignalsProvider;", "deviceIdSignalsProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_signals/DeviceIdSignalsProvider;", "(Lcom/fingerprintjs/android/fingerprint/Fingerprinter$LegacyArgs;Lcom/fingerprintjs/android/fingerprint/fingerprinting_signals/FingerprintingSignalsProvider;Lcom/fingerprintjs/android/fingerprint/device_id_signals/DeviceIdSignalsProvider;)V", "deviceIdResult", "Lcom/fingerprintjs/android/fingerprint/DeviceIdResult;", "executor", "Ljava/util/concurrent/ExecutorService;", "fingerprintResult", "Lcom/fingerprintjs/android/fingerprint/FingerprintResult;", "getDeviceId", "", "listener", "Lkotlin/Function1;", "version", "Lcom/fingerprintjs/android/fingerprint/Fingerprinter$Version;", "getFingerprint", "stabilityLevel", "Lcom/fingerprintjs/android/fingerprint/signal_providers/StabilityLevel;", "hasher", "Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;", "", "fingerprintingSignals", "", "Lcom/fingerprintjs/android/fingerprint/fingerprinting_signals/FingerprintingSignal;", "getFingerprintingSignalsProvider", "hash", "LegacyArgs", "Version", "fingerprint_release"})
public final class Fingerprinter {
    @Nullable
    private final LegacyArgs legacyArgs;
    @NotNull
    private final FingerprintingSignalsProvider fpSignalsProvider;
    @NotNull
    private final DeviceIdSignalsProvider deviceIdSignalsProvider;
    @NotNull
    private final ExecutorService executor;
    @Nullable
    private DeviceIdResult deviceIdResult;
    @Nullable
    private FingerprintResult fingerprintResult;

    public Fingerprinter(@Nullable LegacyArgs legacyArgs, @NotNull FingerprintingSignalsProvider fpSignalsProvider, @NotNull DeviceIdSignalsProvider deviceIdSignalsProvider) {
        Intrinsics.checkNotNullParameter((Object)fpSignalsProvider, (String)"fpSignalsProvider");
        Intrinsics.checkNotNullParameter((Object)deviceIdSignalsProvider, (String)"deviceIdSignalsProvider");
        this.legacyArgs = legacyArgs;
        this.fpSignalsProvider = fpSignalsProvider;
        this.deviceIdSignalsProvider = deviceIdSignalsProvider;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.executor = executorService;
    }

    @Deprecated(message="\n        This method has been deprecated in favor of getDeviceId(version, listener) overload. Check out method doc for details.\n    ")
    public final void getDeviceId(@NotNull Function1<? super DeviceIdResult, Unit> listener) throws IllegalStateException {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        if (this.legacyArgs == null) {
            throw new IllegalStateException("To call this deprecated method, the instancemust be retrieved using deprecated factory method.");
        }
        DeviceIdResult deviceIdResult = this.deviceIdResult;
        if (deviceIdResult != null) {
            DeviceIdResult it = deviceIdResult;
            boolean bl = false;
            listener.invoke((Object)it);
            return;
        }
        this.executor.execute(() -> Fingerprinter.getDeviceId$lambda$1(this, listener));
    }

    public final void getDeviceId(@NotNull Version version, @NotNull Function1<? super DeviceIdResult, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.executor.execute(() -> Fingerprinter.getDeviceId$lambda$2(listener, this, version));
    }

    @Deprecated(message="\n        This method is deprecated in favor of getFingerprint(version,stabilityLevel, hasher, listener)\n        overload. Check out method doc for details.\n        ")
    @JvmOverloads
    public final void getFingerprint(@NotNull StabilityLevel stabilityLevel, @NotNull Function1<? super FingerprintResult, Unit> listener) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)((Object)stabilityLevel), (String)"stabilityLevel");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        if (this.legacyArgs == null) {
            throw new IllegalStateException("To call this deprecated method, the instancemust be retrieved using deprecated factory method.");
        }
        FingerprintResult fingerprintResult = this.fingerprintResult;
        if (fingerprintResult != null) {
            FingerprintResult it = fingerprintResult;
            boolean bl = false;
            listener.invoke((Object)it);
            return;
        }
        this.executor.execute(() -> Fingerprinter.getFingerprint$lambda$5(listener, this, stabilityLevel));
    }

    public static /* synthetic */ void getFingerprint$default(Fingerprinter fingerprinter, StabilityLevel stabilityLevel, Function1 function1, int n, Object object) throws IllegalStateException {
        if ((n & 1) != 0) {
            stabilityLevel = StabilityLevel.OPTIMAL;
        }
        fingerprinter.getFingerprint(stabilityLevel, (Function1<? super FingerprintResult, Unit>)function1);
    }

    @JvmOverloads
    public final void getFingerprint(@NotNull Version version, @NotNull StabilityLevel stabilityLevel, @NotNull Hasher hasher, @NotNull Function1<? super String, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter((Object)((Object)stabilityLevel), (String)"stabilityLevel");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.executor.execute(() -> Fingerprinter.getFingerprint$lambda$7(version, hasher, this, stabilityLevel, listener));
    }

    public static /* synthetic */ void getFingerprint$default(Fingerprinter fingerprinter, Version version, StabilityLevel stabilityLevel, Hasher hasher, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            stabilityLevel = StabilityLevel.OPTIMAL;
        }
        if ((n & 4) != 0) {
            hasher = new MurMur3x64x128Hasher();
        }
        fingerprinter.getFingerprint(version, stabilityLevel, hasher, (Function1<? super String, Unit>)function1);
    }

    @WorkerThread
    @JvmOverloads
    @NotNull
    public final String getFingerprint(@NotNull List<? extends FingerprintingSignal<?>> fingerprintingSignals, @NotNull Hasher hasher) {
        Intrinsics.checkNotNullParameter(fingerprintingSignals, (String)"fingerprintingSignals");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        return this.hash(hasher, fingerprintingSignals);
    }

    public static /* synthetic */ String getFingerprint$default(Fingerprinter fingerprinter, List list, Hasher hasher, int n, Object object) {
        if ((n & 2) != 0) {
            hasher = new MurMur3x64x128Hasher();
        }
        return fingerprinter.getFingerprint(list, hasher);
    }

    private final String hash(Hasher $this$hash, List<? extends FingerprintingSignal<?>> fingerprintingSignals) {
        String joinedString2 = CollectionsKt.joinToString$default((Iterable)fingerprintingSignals, (CharSequence)"", null, null, (int)0, null, (Function1)hash.joinedString.1.INSTANCE, (int)30, null);
        return $this$hash.hash(joinedString2);
    }

    @NotNull
    public final FingerprintingSignalsProvider getFingerprintingSignalsProvider() {
        return this.fpSignalsProvider;
    }

    @Deprecated(message="\n        This method is deprecated in favor of getFingerprint(version,stabilityLevel, hasher, listener)\n        overload. Check out method doc for details.\n        ")
    @JvmOverloads
    public final void getFingerprint(@NotNull Function1<? super FingerprintResult, Unit> listener) throws IllegalStateException {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Fingerprinter.getFingerprint$default(this, null, listener, 1, null);
    }

    @JvmOverloads
    public final void getFingerprint(@NotNull Version version, @NotNull StabilityLevel stabilityLevel, @NotNull Function1<? super String, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter((Object)((Object)stabilityLevel), (String)"stabilityLevel");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Fingerprinter.getFingerprint$default(this, version, stabilityLevel, null, listener, 4, null);
    }

    @JvmOverloads
    public final void getFingerprint(@NotNull Version version, @NotNull Function1<? super String, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Fingerprinter.getFingerprint$default(this, version, null, null, listener, 6, null);
    }

    @WorkerThread
    @JvmOverloads
    @NotNull
    public final String getFingerprint(@NotNull List<? extends FingerprintingSignal<?>> fingerprintingSignals) {
        Intrinsics.checkNotNullParameter(fingerprintingSignals, (String)"fingerprintingSignals");
        return Fingerprinter.getFingerprint$default(this, fingerprintingSignals, null, 2, null);
    }

    private static final void getDeviceId$lambda$1(Fingerprinter this$0, Function1 $listener) {
        DeviceIdResult deviceIdResult;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.deviceIdResult = deviceIdResult = new DeviceIdResult(SignalGroupProvider.fingerprint$default(this$0.legacyArgs.getDeviceIdProvider(), null, 1, null), (String)this$0.legacyArgs.getDeviceIdProvider().rawData().gsfId().getValue(), (String)this$0.legacyArgs.getDeviceIdProvider().rawData().androidId().getValue(), (String)this$0.legacyArgs.getDeviceIdProvider().rawData().mediaDrmId().getValue());
        $listener.invoke((Object)deviceIdResult);
    }

    private static final void getDeviceId$lambda$2(Function1 $listener, Fingerprinter this$0, Version $version) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$version), (String)"$version");
        $listener.invoke((Object)new DeviceIdResult(this$0.deviceIdSignalsProvider.getSignalMatching($version).getIdString(), this$0.deviceIdSignalsProvider.getGsfIdSignal().getIdString(), this$0.deviceIdSignalsProvider.getAndroidIdSignal().getIdString(), this$0.deviceIdSignalsProvider.getMediaDrmIdSignal().getIdString()));
    }

    private static final void getFingerprint$lambda$5(Function1 $listener, Fingerprinter this$0, StabilityLevel $stabilityLevel) {
        StringBuilder fingerprintSb;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$stabilityLevel), (String)"$stabilityLevel");
        StringBuilder $this$getFingerprint_u24lambda_u245_u24lambda_u244 = stringBuilder = (fingerprintSb = new StringBuilder());
        boolean bl = false;
        $this$getFingerprint_u24lambda_u245_u24lambda_u244.append(this$0.legacyArgs.getHardwareSignalProvider().fingerprint($stabilityLevel));
        $this$getFingerprint_u24lambda_u245_u24lambda_u244.append(this$0.legacyArgs.getOsBuildSignalProvider().fingerprint($stabilityLevel));
        $this$getFingerprint_u24lambda_u245_u24lambda_u244.append(this$0.legacyArgs.getDeviceStateSignalProvider().fingerprint($stabilityLevel));
        $this$getFingerprint_u24lambda_u245_u24lambda_u244.append(this$0.legacyArgs.getInstalledAppsSignalProvider().fingerprint($stabilityLevel));
        FingerprintResult result2 = new FingerprintResult(this$0, fingerprintSb){
            @NotNull
            private final String fingerprint;
            final /* synthetic */ Fingerprinter this$0;
            {
                this.this$0 = $receiver;
                Hasher hasher = Fingerprinter.access$getLegacyArgs$p($receiver).getConfiguration().getHasher();
                String string = $fingerprintSb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fingerprintSb.toString()");
                this.fingerprint = hasher.hash(string);
            }

            @NotNull
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Nullable
            public <T extends SignalGroupProvider<?>> T getSignalProvider(@NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                Class<T> clazz2 = clazz;
                SignalGroupProvider<T> signalGroupProvider = Intrinsics.areEqual(clazz2, HardwareSignalGroupProvider.class) ? (SignalGroupProvider<T>)Fingerprinter.access$getLegacyArgs$p(this.this$0).getHardwareSignalProvider() : (Intrinsics.areEqual(clazz2, OsBuildSignalGroupProvider.class) ? (SignalGroupProvider)Fingerprinter.access$getLegacyArgs$p(this.this$0).getOsBuildSignalProvider() : (Intrinsics.areEqual(clazz2, DeviceStateSignalGroupProvider.class) ? (SignalGroupProvider)Fingerprinter.access$getLegacyArgs$p(this.this$0).getDeviceStateSignalProvider() : (Intrinsics.areEqual(clazz2, InstalledAppsSignalGroupProvider.class) ? (SignalGroupProvider)Fingerprinter.access$getLegacyArgs$p(this.this$0).getInstalledAppsSignalProvider() : (Intrinsics.areEqual(clazz2, DeviceIdProvider.class) ? (SignalGroupProvider)Fingerprinter.access$getLegacyArgs$p(this.this$0).getDeviceIdProvider() : null))));
                return (T)(signalGroupProvider instanceof SignalGroupProvider ? signalGroupProvider : null);
            }
        };
        $listener.invoke((Object)result2);
    }

    private static final void getFingerprint$lambda$7(Version $version, Hasher $hasher, Fingerprinter this$0, StabilityLevel $stabilityLevel, Function1 $listener) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)$version), (String)"$version");
        Intrinsics.checkNotNullParameter((Object)$hasher, (String)"$hasher");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$stabilityLevel), (String)"$stabilityLevel");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        if ($version.compareTo((Enum)Version.Companion.getFingerprintingFlattenedSignalsFirstVersion$fingerprint_release()) < 0) {
            FingerprintingLegacySchemeSupportExtensions $this$getFingerprint_u24lambda_u247_u24lambda_u246 = FingerprintingLegacySchemeSupportExtensions.INSTANCE;
            boolean bl = false;
            Object[] objectArray = new String[]{this$0.hash($hasher, $this$getFingerprint_u24lambda_u247_u24lambda_u246.getHardwareSignals(this$0.fpSignalsProvider, $version, $stabilityLevel)), this$0.hash($hasher, $this$getFingerprint_u24lambda_u247_u24lambda_u246.getOsBuildSignals(this$0.fpSignalsProvider, $version, $stabilityLevel)), this$0.hash($hasher, $this$getFingerprint_u24lambda_u247_u24lambda_u246.getDeviceStateSignals(this$0.fpSignalsProvider, $version, $stabilityLevel)), this$0.hash($hasher, $this$getFingerprint_u24lambda_u247_u24lambda_u246.getInstalledAppsSignals(this$0.fpSignalsProvider, $version, $stabilityLevel))};
            String joinedHashes = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            string = $hasher.hash(joinedHashes);
        } else {
            string = this$0.getFingerprint(this$0.fpSignalsProvider.getSignalsMatching($version, $stabilityLevel), $hasher);
        }
        String result2 = string;
        $listener.invoke((Object)result2);
    }

    public static final /* synthetic */ LegacyArgs access$getLegacyArgs$p(Fingerprinter $this) {
        return $this.legacyArgs;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003J\t\u0010 \u001a\u00020\rH\u00c6\u0003JE\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lcom/fingerprintjs/android/fingerprint/Fingerprinter$LegacyArgs;", "", "hardwareSignalProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareSignalGroupProvider;", "osBuildSignalProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/os_build/OsBuildSignalGroupProvider;", "deviceIdProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/device_id/DeviceIdProvider;", "installedAppsSignalProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/installed_apps/InstalledAppsSignalGroupProvider;", "deviceStateSignalProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/device_state/DeviceStateSignalGroupProvider;", "configuration", "Lcom/fingerprintjs/android/fingerprint/Configuration;", "(Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareSignalGroupProvider;Lcom/fingerprintjs/android/fingerprint/signal_providers/os_build/OsBuildSignalGroupProvider;Lcom/fingerprintjs/android/fingerprint/signal_providers/device_id/DeviceIdProvider;Lcom/fingerprintjs/android/fingerprint/signal_providers/installed_apps/InstalledAppsSignalGroupProvider;Lcom/fingerprintjs/android/fingerprint/signal_providers/device_state/DeviceStateSignalGroupProvider;Lcom/fingerprintjs/android/fingerprint/Configuration;)V", "getConfiguration", "()Lcom/fingerprintjs/android/fingerprint/Configuration;", "getDeviceIdProvider", "()Lcom/fingerprintjs/android/fingerprint/signal_providers/device_id/DeviceIdProvider;", "getDeviceStateSignalProvider", "()Lcom/fingerprintjs/android/fingerprint/signal_providers/device_state/DeviceStateSignalGroupProvider;", "getHardwareSignalProvider", "()Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareSignalGroupProvider;", "getInstalledAppsSignalProvider", "()Lcom/fingerprintjs/android/fingerprint/signal_providers/installed_apps/InstalledAppsSignalGroupProvider;", "getOsBuildSignalProvider", "()Lcom/fingerprintjs/android/fingerprint/signal_providers/os_build/OsBuildSignalGroupProvider;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fingerprint_release"})
    public static final class LegacyArgs {
        @NotNull
        private final HardwareSignalGroupProvider hardwareSignalProvider;
        @NotNull
        private final OsBuildSignalGroupProvider osBuildSignalProvider;
        @NotNull
        private final DeviceIdProvider deviceIdProvider;
        @NotNull
        private final InstalledAppsSignalGroupProvider installedAppsSignalProvider;
        @NotNull
        private final DeviceStateSignalGroupProvider deviceStateSignalProvider;
        @NotNull
        private final Configuration configuration;

        public LegacyArgs(@NotNull HardwareSignalGroupProvider hardwareSignalProvider, @NotNull OsBuildSignalGroupProvider osBuildSignalProvider, @NotNull DeviceIdProvider deviceIdProvider, @NotNull InstalledAppsSignalGroupProvider installedAppsSignalProvider, @NotNull DeviceStateSignalGroupProvider deviceStateSignalProvider, @NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)hardwareSignalProvider, (String)"hardwareSignalProvider");
            Intrinsics.checkNotNullParameter((Object)osBuildSignalProvider, (String)"osBuildSignalProvider");
            Intrinsics.checkNotNullParameter((Object)deviceIdProvider, (String)"deviceIdProvider");
            Intrinsics.checkNotNullParameter((Object)installedAppsSignalProvider, (String)"installedAppsSignalProvider");
            Intrinsics.checkNotNullParameter((Object)deviceStateSignalProvider, (String)"deviceStateSignalProvider");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.hardwareSignalProvider = hardwareSignalProvider;
            this.osBuildSignalProvider = osBuildSignalProvider;
            this.deviceIdProvider = deviceIdProvider;
            this.installedAppsSignalProvider = installedAppsSignalProvider;
            this.deviceStateSignalProvider = deviceStateSignalProvider;
            this.configuration = configuration;
        }

        @NotNull
        public final HardwareSignalGroupProvider getHardwareSignalProvider() {
            return this.hardwareSignalProvider;
        }

        @NotNull
        public final OsBuildSignalGroupProvider getOsBuildSignalProvider() {
            return this.osBuildSignalProvider;
        }

        @NotNull
        public final DeviceIdProvider getDeviceIdProvider() {
            return this.deviceIdProvider;
        }

        @NotNull
        public final InstalledAppsSignalGroupProvider getInstalledAppsSignalProvider() {
            return this.installedAppsSignalProvider;
        }

        @NotNull
        public final DeviceStateSignalGroupProvider getDeviceStateSignalProvider() {
            return this.deviceStateSignalProvider;
        }

        @NotNull
        public final Configuration getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final HardwareSignalGroupProvider component1() {
            return this.hardwareSignalProvider;
        }

        @NotNull
        public final OsBuildSignalGroupProvider component2() {
            return this.osBuildSignalProvider;
        }

        @NotNull
        public final DeviceIdProvider component3() {
            return this.deviceIdProvider;
        }

        @NotNull
        public final InstalledAppsSignalGroupProvider component4() {
            return this.installedAppsSignalProvider;
        }

        @NotNull
        public final DeviceStateSignalGroupProvider component5() {
            return this.deviceStateSignalProvider;
        }

        @NotNull
        public final Configuration component6() {
            return this.configuration;
        }

        @NotNull
        public final LegacyArgs copy(@NotNull HardwareSignalGroupProvider hardwareSignalProvider, @NotNull OsBuildSignalGroupProvider osBuildSignalProvider, @NotNull DeviceIdProvider deviceIdProvider, @NotNull InstalledAppsSignalGroupProvider installedAppsSignalProvider, @NotNull DeviceStateSignalGroupProvider deviceStateSignalProvider, @NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)hardwareSignalProvider, (String)"hardwareSignalProvider");
            Intrinsics.checkNotNullParameter((Object)osBuildSignalProvider, (String)"osBuildSignalProvider");
            Intrinsics.checkNotNullParameter((Object)deviceIdProvider, (String)"deviceIdProvider");
            Intrinsics.checkNotNullParameter((Object)installedAppsSignalProvider, (String)"installedAppsSignalProvider");
            Intrinsics.checkNotNullParameter((Object)deviceStateSignalProvider, (String)"deviceStateSignalProvider");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            return new LegacyArgs(hardwareSignalProvider, osBuildSignalProvider, deviceIdProvider, installedAppsSignalProvider, deviceStateSignalProvider, configuration);
        }

        public static /* synthetic */ LegacyArgs copy$default(LegacyArgs legacyArgs, HardwareSignalGroupProvider hardwareSignalGroupProvider, OsBuildSignalGroupProvider osBuildSignalGroupProvider, DeviceIdProvider deviceIdProvider, InstalledAppsSignalGroupProvider installedAppsSignalGroupProvider, DeviceStateSignalGroupProvider deviceStateSignalGroupProvider, Configuration configuration, int n, Object object) {
            if ((n & 1) != 0) {
                hardwareSignalGroupProvider = legacyArgs.hardwareSignalProvider;
            }
            if ((n & 2) != 0) {
                osBuildSignalGroupProvider = legacyArgs.osBuildSignalProvider;
            }
            if ((n & 4) != 0) {
                deviceIdProvider = legacyArgs.deviceIdProvider;
            }
            if ((n & 8) != 0) {
                installedAppsSignalGroupProvider = legacyArgs.installedAppsSignalProvider;
            }
            if ((n & 0x10) != 0) {
                deviceStateSignalGroupProvider = legacyArgs.deviceStateSignalProvider;
            }
            if ((n & 0x20) != 0) {
                configuration = legacyArgs.configuration;
            }
            return legacyArgs.copy(hardwareSignalGroupProvider, osBuildSignalGroupProvider, deviceIdProvider, installedAppsSignalGroupProvider, deviceStateSignalGroupProvider, configuration);
        }

        @NotNull
        public String toString() {
            return "LegacyArgs(hardwareSignalProvider=" + this.hardwareSignalProvider + ", osBuildSignalProvider=" + this.osBuildSignalProvider + ", deviceIdProvider=" + this.deviceIdProvider + ", installedAppsSignalProvider=" + this.installedAppsSignalProvider + ", deviceStateSignalProvider=" + this.deviceStateSignalProvider + ", configuration=" + this.configuration + ')';
        }

        public int hashCode() {
            int result2 = this.hardwareSignalProvider.hashCode();
            result2 = result2 * 31 + this.osBuildSignalProvider.hashCode();
            result2 = result2 * 31 + this.deviceIdProvider.hashCode();
            result2 = result2 * 31 + this.installedAppsSignalProvider.hashCode();
            result2 = result2 * 31 + this.deviceStateSignalProvider.hashCode();
            result2 = result2 * 31 + this.configuration.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LegacyArgs)) {
                return false;
            }
            LegacyArgs legacyArgs = (LegacyArgs)other;
            if (!Intrinsics.areEqual((Object)this.hardwareSignalProvider, (Object)legacyArgs.hardwareSignalProvider)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.osBuildSignalProvider, (Object)legacyArgs.osBuildSignalProvider)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.deviceIdProvider, (Object)legacyArgs.deviceIdProvider)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.installedAppsSignalProvider, (Object)legacyArgs.installedAppsSignalProvider)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.deviceStateSignalProvider, (Object)legacyArgs.deviceStateSignalProvider)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configuration, (Object)legacyArgs.configuration);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0001\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/fingerprintjs/android/fingerprint/Fingerprinter$Version;", "", "intValue", "", "(Ljava/lang/String;II)V", "getIntValue$fingerprint_release", "()I", "V_1", "V_2", "V_3", "V_4", "V_5", "Companion", "fingerprint_release"})
    public static final class Version
    extends Enum<Version> {
        @NotNull
        public static final Companion Companion;
        private final int intValue;
        public static final /* enum */ Version V_1;
        public static final /* enum */ Version V_2;
        public static final /* enum */ Version V_3;
        public static final /* enum */ Version V_4;
        public static final /* enum */ Version V_5;
        private static final /* synthetic */ Version[] $VALUES;

        private Version(int intValue) {
            this.intValue = intValue;
        }

        public final int getIntValue$fingerprint_release() {
            return this.intValue;
        }

        public static Version[] values() {
            return (Version[])$VALUES.clone();
        }

        public static Version valueOf(String value) {
            return Enum.valueOf(Version.class, value);
        }

        static {
            V_1 = new Version(1);
            V_2 = new Version(2);
            V_3 = new Version(3);
            V_4 = new Version(4);
            V_5 = new Version(5);
            $VALUES = versionArray = new Version[]{Version.V_1, Version.V_2, Version.V_3, Version.V_4, Version.V_5};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/fingerprintjs/android/fingerprint/Fingerprinter$Version$Companion;", "", "()V", "fingerprintingFlattenedSignalsFirstVersion", "Lcom/fingerprintjs/android/fingerprint/Fingerprinter$Version;", "getFingerprintingFlattenedSignalsFirstVersion$fingerprint_release", "()Lcom/fingerprintjs/android/fingerprint/Fingerprinter$Version;", "fingerprintingGroupedSignalsLastVersion", "getFingerprintingGroupedSignalsLastVersion$fingerprint_release", "latest", "getLatest", "fingerprint_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Version getLatest() {
                return (Version)((Object)ArraysKt.last((Object[])Version.values()));
            }

            @NotNull
            public final Version getFingerprintingFlattenedSignalsFirstVersion$fingerprint_release() {
                return V_5;
            }

            @NotNull
            public final Version getFingerprintingGroupedSignalsLastVersion$fingerprint_release() {
                return V_4;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

