/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint.signal_providers.device_id;

import com.fingerprintjs.android.fingerprint.device_id_providers.AndroidIdProvider;
import com.fingerprintjs.android.fingerprint.device_id_providers.GsfIdProvider;
import com.fingerprintjs.android.fingerprint.device_id_providers.MediaDrmIdProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.SignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.StabilityLevel;
import com.fingerprintjs.android.fingerprint.signal_providers.device_id.DeviceIdRawData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/fingerprintjs/android/fingerprint/signal_providers/device_id/DeviceIdProvider;", "Lcom/fingerprintjs/android/fingerprint/signal_providers/SignalGroupProvider;", "Lcom/fingerprintjs/android/fingerprint/signal_providers/device_id/DeviceIdRawData;", "gsfIdProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_providers/GsfIdProvider;", "androidIdProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_providers/AndroidIdProvider;", "mediaDrmIdProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_providers/MediaDrmIdProvider;", "version", "", "(Lcom/fingerprintjs/android/fingerprint/device_id_providers/GsfIdProvider;Lcom/fingerprintjs/android/fingerprint/device_id_providers/AndroidIdProvider;Lcom/fingerprintjs/android/fingerprint/device_id_providers/MediaDrmIdProvider;I)V", "rawData", "fingerprint", "", "stabilityLevel", "Lcom/fingerprintjs/android/fingerprint/signal_providers/StabilityLevel;", "v1", "v3", "fingerprint_release"})
public final class DeviceIdProvider
extends SignalGroupProvider<DeviceIdRawData> {
    @NotNull
    private final DeviceIdRawData rawData;

    public DeviceIdProvider(@NotNull GsfIdProvider gsfIdProvider, @NotNull AndroidIdProvider androidIdProvider, @NotNull MediaDrmIdProvider mediaDrmIdProvider, int version) {
        Intrinsics.checkNotNullParameter((Object)gsfIdProvider, (String)"gsfIdProvider");
        Intrinsics.checkNotNullParameter((Object)androidIdProvider, (String)"androidIdProvider");
        Intrinsics.checkNotNullParameter((Object)mediaDrmIdProvider, (String)"mediaDrmIdProvider");
        super(version);
        this.rawData = new DeviceIdRawData(androidIdProvider.getAndroidId(), gsfIdProvider.getGsfAndroidId(), mediaDrmIdProvider.getMediaDrmId());
    }

    @Override
    @NotNull
    public DeviceIdRawData rawData() {
        return this.rawData;
    }

    @Override
    @NotNull
    public String fingerprint(@NotNull StabilityLevel stabilityLevel) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)stabilityLevel), (String)"stabilityLevel");
        int n = this.getVersion();
        switch (n) {
            case 1: {
                string = this.v1();
                break;
            }
            case 2: {
                string = this.v1();
                break;
            }
            case 3: {
                string = this.v3();
                break;
            }
            default: {
                string = this.v3();
            }
        }
        return string;
    }

    private final String v1() {
        CharSequence charSequence = (CharSequence)this.rawData.gsfId().getValue();
        boolean bl = false;
        return (String)(charSequence.length() == 0 ? this.rawData.androidId() : this.rawData.gsfId()).getValue();
    }

    private final String v3() {
        String string;
        CharSequence charSequence = (CharSequence)this.rawData.gsfId().getValue();
        boolean bl = false;
        String gsfId2 = charSequence.length() == 0 ? (String)null : (String)this.rawData.gsfId().getValue();
        CharSequence charSequence2 = (CharSequence)this.rawData.mediaDrmId().getValue();
        boolean bl2 = false;
        String mediaDrmId2 = charSequence2.length() == 0 ? (String)null : (String)this.rawData.mediaDrmId().getValue();
        charSequence2 = gsfId2;
        return charSequence2 == null ? ((string = mediaDrmId2) == null ? (String)this.rawData.androidId().getValue() : string) : charSequence2;
    }
}

