/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint;

import com.fingerprintjs.android.fingerprint.Configuration;
import com.fingerprintjs.android.fingerprint.DeviceIdResult;
import com.fingerprintjs.android.fingerprint.FingerprintResult;
import com.fingerprintjs.android.fingerprint.Fingerprinter;
import com.fingerprintjs.android.fingerprint.signal_providers.SignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.StabilityLevel;
import com.fingerprintjs.android.fingerprint.signal_providers.device_id.DeviceIdProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.device_state.DeviceStateSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.hardware.HardwareSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.installed_apps.InstalledAppsSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.os_build.OsBuildSignalGroupProvider;
import com.fingerprintjs.android.fingerprint.tools.hashers.Hasher;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160\u001aH\u0002J\u001c\u0010\u001b\u001a\u00020\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00160\u001aH\u0016J\u001c\u0010\u001c\u001a\u00020\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160\u001aH\u0016J$\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160\u001aH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/fingerprintjs/android/fingerprint/FingerprinterImpl;", "Lcom/fingerprintjs/android/fingerprint/Fingerprinter;", "hardwareSignalProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareSignalGroupProvider;", "osBuildSignalProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/os_build/OsBuildSignalGroupProvider;", "deviceIdProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/device_id/DeviceIdProvider;", "installedAppsSignalProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/installed_apps/InstalledAppsSignalGroupProvider;", "deviceStateSignalProvider", "Lcom/fingerprintjs/android/fingerprint/signal_providers/device_state/DeviceStateSignalGroupProvider;", "configuration", "Lcom/fingerprintjs/android/fingerprint/Configuration;", "(Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareSignalGroupProvider;Lcom/fingerprintjs/android/fingerprint/signal_providers/os_build/OsBuildSignalGroupProvider;Lcom/fingerprintjs/android/fingerprint/signal_providers/device_id/DeviceIdProvider;Lcom/fingerprintjs/android/fingerprint/signal_providers/installed_apps/InstalledAppsSignalGroupProvider;Lcom/fingerprintjs/android/fingerprint/signal_providers/device_state/DeviceStateSignalGroupProvider;Lcom/fingerprintjs/android/fingerprint/Configuration;)V", "deviceIdResult", "Lcom/fingerprintjs/android/fingerprint/DeviceIdResult;", "executor", "Ljava/util/concurrent/ExecutorService;", "fingerprintResult", "Lcom/fingerprintjs/android/fingerprint/FingerprintResult;", "calculateFingerprint", "", "stabilityLevel", "Lcom/fingerprintjs/android/fingerprint/signal_providers/StabilityLevel;", "listener", "Lkotlin/Function1;", "getDeviceId", "getFingerprint", "fingerprint_release"})
public final class FingerprinterImpl
implements Fingerprinter {
    @NotNull
    private final HardwareSignalGroupProvider hardwareSignalProvider;
    @NotNull
    private final OsBuildSignalGroupProvider osBuildSignalProvider;
    @NotNull
    private final DeviceIdProvider deviceIdProvider;
    @NotNull
    private final InstalledAppsSignalGroupProvider installedAppsSignalProvider;
    @NotNull
    private final DeviceStateSignalGroupProvider deviceStateSignalProvider;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final ExecutorService executor;
    @Nullable
    private DeviceIdResult deviceIdResult;
    @Nullable
    private FingerprintResult fingerprintResult;

    public FingerprinterImpl(@NotNull HardwareSignalGroupProvider hardwareSignalProvider, @NotNull OsBuildSignalGroupProvider osBuildSignalProvider, @NotNull DeviceIdProvider deviceIdProvider, @NotNull InstalledAppsSignalGroupProvider installedAppsSignalProvider, @NotNull DeviceStateSignalGroupProvider deviceStateSignalProvider, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)hardwareSignalProvider, (String)"hardwareSignalProvider");
        Intrinsics.checkNotNullParameter((Object)osBuildSignalProvider, (String)"osBuildSignalProvider");
        Intrinsics.checkNotNullParameter((Object)deviceIdProvider, (String)"deviceIdProvider");
        Intrinsics.checkNotNullParameter((Object)installedAppsSignalProvider, (String)"installedAppsSignalProvider");
        Intrinsics.checkNotNullParameter((Object)deviceStateSignalProvider, (String)"deviceStateSignalProvider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.hardwareSignalProvider = hardwareSignalProvider;
        this.osBuildSignalProvider = osBuildSignalProvider;
        this.deviceIdProvider = deviceIdProvider;
        this.installedAppsSignalProvider = installedAppsSignalProvider;
        this.deviceStateSignalProvider = deviceStateSignalProvider;
        this.configuration = configuration;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.executor = executorService;
    }

    @Override
    public void getDeviceId(@NotNull Function1<? super DeviceIdResult, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        DeviceIdResult deviceIdResult = this.deviceIdResult;
        if (deviceIdResult != null) {
            DeviceIdResult deviceIdResult2 = deviceIdResult;
            boolean bl = false;
            boolean bl2 = false;
            DeviceIdResult it = deviceIdResult2;
            boolean bl3 = false;
            listener.invoke((Object)it);
            return;
        }
        this.executor.execute(() -> FingerprinterImpl.getDeviceId$lambda-1(this, listener));
    }

    @Override
    public void getFingerprint(@NotNull Function1<? super FingerprintResult, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.getFingerprint(StabilityLevel.OPTIMAL, listener);
    }

    @Override
    public void getFingerprint(@NotNull StabilityLevel stabilityLevel, @NotNull Function1<? super FingerprintResult, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)stabilityLevel), (String)"stabilityLevel");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.calculateFingerprint(stabilityLevel, listener);
    }

    private final void calculateFingerprint(StabilityLevel stabilityLevel, Function1<? super FingerprintResult, Unit> listener) {
        FingerprintResult fingerprintResult = this.fingerprintResult;
        if (fingerprintResult != null) {
            FingerprintResult fingerprintResult2 = fingerprintResult;
            boolean bl = false;
            boolean bl2 = false;
            FingerprintResult it = fingerprintResult2;
            boolean bl3 = false;
            listener.invoke((Object)it);
            return;
        }
        this.executor.execute(() -> FingerprinterImpl.calculateFingerprint$lambda-4(listener, this, stabilityLevel));
    }

    private static final void getDeviceId$lambda-1(FingerprinterImpl this$0, Function1 $listener) {
        DeviceIdResult deviceIdResult;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.deviceIdResult = deviceIdResult = new DeviceIdResult(SignalGroupProvider.fingerprint$default(this$0.deviceIdProvider, null, 1, null), (String)this$0.deviceIdProvider.rawData().gsfId().getValue(), (String)this$0.deviceIdProvider.rawData().androidId().getValue(), (String)this$0.deviceIdProvider.rawData().mediaDrmId().getValue());
        $listener.invoke((Object)deviceIdResult);
    }

    private static final void calculateFingerprint$lambda-4(Function1 $listener, FingerprinterImpl this$0, StabilityLevel $stabilityLevel) {
        StringBuilder fingerprintSb;
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$stabilityLevel), (String)"$stabilityLevel");
        StringBuilder stringBuilder = fingerprintSb = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$calculateFingerprint_u24lambda_u2d4_u24lambda_u2d3 = stringBuilder;
        boolean bl3 = false;
        $this$calculateFingerprint_u24lambda_u2d4_u24lambda_u2d3.append(this$0.hardwareSignalProvider.fingerprint($stabilityLevel));
        $this$calculateFingerprint_u24lambda_u2d4_u24lambda_u2d3.append(this$0.osBuildSignalProvider.fingerprint($stabilityLevel));
        $this$calculateFingerprint_u24lambda_u2d4_u24lambda_u2d3.append(this$0.deviceStateSignalProvider.fingerprint($stabilityLevel));
        $this$calculateFingerprint_u24lambda_u2d4_u24lambda_u2d3.append(this$0.installedAppsSignalProvider.fingerprint($stabilityLevel));
        FingerprintResult result2 = new FingerprintResult(this$0, fingerprintSb){
            @NotNull
            private final String fingerprint;
            final /* synthetic */ FingerprinterImpl this$0;
            final /* synthetic */ StringBuilder $fingerprintSb;
            {
                this.this$0 = $receiver;
                this.$fingerprintSb = $fingerprintSb;
                Hasher hasher = FingerprinterImpl.access$getConfiguration$p(this.this$0).getHasher();
                String string = this.$fingerprintSb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fingerprintSb.toString()");
                this.fingerprint = hasher.hash(string);
            }

            @NotNull
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Nullable
            public <T> T getSignalProvider(@NotNull Class<T> clazz) {
                SignalGroupProvider<T> signalGroupProvider;
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                Class<T> clazz2 = clazz;
                SignalGroupProvider<T> signalGroupProvider2 = Intrinsics.areEqual(clazz2, HardwareSignalGroupProvider.class) ? (SignalGroupProvider<T>)FingerprinterImpl.access$getHardwareSignalProvider$p(this.this$0) : (Intrinsics.areEqual(clazz2, OsBuildSignalGroupProvider.class) ? (SignalGroupProvider)FingerprinterImpl.access$getOsBuildSignalProvider$p(this.this$0) : (Intrinsics.areEqual(clazz2, DeviceStateSignalGroupProvider.class) ? (SignalGroupProvider)FingerprinterImpl.access$getDeviceStateSignalProvider$p(this.this$0) : (Intrinsics.areEqual(clazz2, InstalledAppsSignalGroupProvider.class) ? (SignalGroupProvider)FingerprinterImpl.access$getInstalledAppsSignalProvider$p(this.this$0) : (signalGroupProvider = Intrinsics.areEqual(clazz2, DeviceIdProvider.class) ? (SignalGroupProvider)FingerprinterImpl.access$getDeviceIdProvider$p(this.this$0) : null))));
                if (signalGroupProvider == null) {
                    // empty if block
                }
                return (T)signalGroupProvider;
            }
        };
        $listener.invoke((Object)result2);
    }

    public static final /* synthetic */ Configuration access$getConfiguration$p(FingerprinterImpl $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ HardwareSignalGroupProvider access$getHardwareSignalProvider$p(FingerprinterImpl $this) {
        return $this.hardwareSignalProvider;
    }

    public static final /* synthetic */ OsBuildSignalGroupProvider access$getOsBuildSignalProvider$p(FingerprinterImpl $this) {
        return $this.osBuildSignalProvider;
    }

    public static final /* synthetic */ DeviceStateSignalGroupProvider access$getDeviceStateSignalProvider$p(FingerprinterImpl $this) {
        return $this.deviceStateSignalProvider;
    }

    public static final /* synthetic */ InstalledAppsSignalGroupProvider access$getInstalledAppsSignalProvider$p(FingerprinterImpl $this) {
        return $this.installedAppsSignalProvider;
    }

    public static final /* synthetic */ DeviceIdProvider access$getDeviceIdProvider$p(FingerprinterImpl $this) {
        return $this.deviceIdProvider;
    }
}

