/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.hardware.SensorManager;
import android.hardware.input.InputManager;
import android.media.RingtoneManager;
import android.os.Environment;
import android.os.StatFs;
import androidx.core.hardware.fingerprint.FingerprintManagerCompat;
import com.fingerprintjs.android.fingerprint.Configuration;
import com.fingerprintjs.android.fingerprint.Fingerprinter;
import com.fingerprintjs.android.fingerprint.FingerprinterImpl;
import com.fingerprintjs.android.fingerprint.datasources.CpuInfoProvider;
import com.fingerprintjs.android.fingerprint.datasources.CpuInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.datasources.DevicePersonalizationDataSource;
import com.fingerprintjs.android.fingerprint.datasources.DevicePersonalizationDataSourceImpl;
import com.fingerprintjs.android.fingerprint.datasources.FingerprintSensorInfoProvider;
import com.fingerprintjs.android.fingerprint.datasources.FingerprintSensorInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.datasources.InputDeviceDataSource;
import com.fingerprintjs.android.fingerprint.datasources.InputDevicesDataSourceImpl;
import com.fingerprintjs.android.fingerprint.datasources.KeyGuardInfoProvider;
import com.fingerprintjs.android.fingerprint.datasources.KeyGuardInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.datasources.MemInfoProvider;
import com.fingerprintjs.android.fingerprint.datasources.MemInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.datasources.OsBuildInfoProvider;
import com.fingerprintjs.android.fingerprint.datasources.OsBuildInfoProviderImpl;
import com.fingerprintjs.android.fingerprint.datasources.PackageManagerDataSource;
import com.fingerprintjs.android.fingerprint.datasources.PackageManagerDataSourceImpl;
import com.fingerprintjs.android.fingerprint.datasources.SensorDataSource;
import com.fingerprintjs.android.fingerprint.datasources.SensorDataSourceImpl;
import com.fingerprintjs.android.fingerprint.datasources.SettingsDataSource;
import com.fingerprintjs.android.fingerprint.datasources.SettingsDataSourceImpl;
import com.fingerprintjs.android.fingerprint.device_id_providers.AndroidIdProvider;
import com.fingerprintjs.android.fingerprint.device_id_providers.DeviceIdProvider;
import com.fingerprintjs.android.fingerprint.device_id_providers.DeviceIdProviderImpl;
import com.fingerprintjs.android.fingerprint.device_id_providers.GsfIdProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.device_state.DeviceStateSignalProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.hardware.HardwareSignalProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.installed_apps.InstalledAppsSignalProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.os_build.OsBuildSignalProvider;
import com.fingerprintjs.android.fingerprint.tools.hashers.Hasher;
import com.fingerprintjs.android.fingerprint.tools.hashers.MurMur3x64x128Hasher;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0007J\u0018\u0010.\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/fingerprintjs/android/fingerprint/FingerprinterFactory;", "", "()V", "configuration", "Lcom/fingerprintjs/android/fingerprint/Configuration;", "context", "Landroid/content/Context;", "hasher", "Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;", "instance", "Lcom/fingerprintjs/android/fingerprint/Fingerprinter;", "createAndroidIdProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_providers/AndroidIdProvider;", "createCpuInfoProvider", "Lcom/fingerprintjs/android/fingerprint/datasources/CpuInfoProvider;", "createDeviceIdProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_providers/DeviceIdProvider;", "createDevicePersonalizationDataSource", "Lcom/fingerprintjs/android/fingerprint/datasources/DevicePersonalizationDataSource;", "createDeviceStateFingerprinter", "Lcom/fingerprintjs/android/fingerprint/signal_providers/device_state/DeviceStateSignalProvider;", "createFingerprintSensorStatusProvider", "Lcom/fingerprintjs/android/fingerprint/datasources/FingerprintSensorInfoProvider;", "createGsfIdProvider", "Lcom/fingerprintjs/android/fingerprint/device_id_providers/GsfIdProvider;", "createHardwareFingerprinter", "Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareSignalProvider;", "createInputDevicesDataSource", "Lcom/fingerprintjs/android/fingerprint/datasources/InputDeviceDataSource;", "createInstalledApplicationsFingerprinter", "Lcom/fingerprintjs/android/fingerprint/signal_providers/installed_apps/InstalledAppsSignalProvider;", "createKeyGuardInfoProvider", "Lcom/fingerprintjs/android/fingerprint/datasources/KeyGuardInfoProvider;", "createMemoryInfoProvider", "Lcom/fingerprintjs/android/fingerprint/datasources/MemInfoProvider;", "createOsBuildInfoFingerprinter", "Lcom/fingerprintjs/android/fingerprint/signal_providers/os_build/OsBuildSignalProvider;", "createOsBuildInfoProvider", "Lcom/fingerprintjs/android/fingerprint/datasources/OsBuildInfoProvider;", "createPackageManagerDataSource", "Lcom/fingerprintjs/android/fingerprint/datasources/PackageManagerDataSource;", "createSensorDataSource", "Lcom/fingerprintjs/android/fingerprint/datasources/SensorDataSource;", "createSettingsDataSource", "Lcom/fingerprintjs/android/fingerprint/datasources/SettingsDataSource;", "getInstance", "initializeFingerprinter", "fingerprint_release"})
public final class FingerprinterFactory {
    private static Configuration configuration;
    private static Fingerprinter instance;
    private static Hasher hasher;
    private static Context context;
    public static final FingerprinterFactory INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Fingerprinter getInstance(@NotNull Context context, @NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        if (Intrinsics.areEqual((Object)FingerprinterFactory.configuration, (Object)configuration) ^ true) {
            instance = null;
        }
        if (instance == null) {
            Class<FingerprinterFactory> clazz = FingerprinterFactory.class;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (clazz) {
                boolean bl3 = false;
                if (instance == null) {
                    instance = INSTANCE.initializeFingerprinter(context, configuration);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        Fingerprinter fingerprinter = instance;
        if (fingerprinter == null) {
            Intrinsics.throwNpe();
        }
        return fingerprinter;
    }

    private final Fingerprinter initializeFingerprinter(Context context, Configuration configuration) {
        FingerprinterFactory.configuration = configuration;
        FingerprinterFactory.context = context;
        hasher = configuration.getHasher();
        return new FingerprinterImpl(this.createHardwareFingerprinter(), this.createOsBuildInfoFingerprinter(), this.createDeviceIdProvider(), this.createInstalledApplicationsFingerprinter(), this.createDeviceStateFingerprinter(), configuration);
    }

    private final HardwareSignalProvider createHardwareFingerprinter() {
        return new HardwareSignalProvider(this.createCpuInfoProvider(), this.createMemoryInfoProvider(), this.createOsBuildInfoProvider(), this.createSensorDataSource(), this.createInputDevicesDataSource(), hasher, configuration.getVersion());
    }

    private final OsBuildSignalProvider createOsBuildInfoFingerprinter() {
        return new OsBuildSignalProvider(this.createOsBuildInfoProvider(), hasher, configuration.getVersion());
    }

    private final InstalledAppsSignalProvider createInstalledApplicationsFingerprinter() {
        return new InstalledAppsSignalProvider(this.createPackageManagerDataSource(), hasher, configuration.getVersion());
    }

    private final DeviceStateSignalProvider createDeviceStateFingerprinter() {
        return new DeviceStateSignalProvider(this.createSettingsDataSource(), this.createDevicePersonalizationDataSource(), this.createKeyGuardInfoProvider(), this.createFingerprintSensorStatusProvider(), hasher, configuration.getVersion());
    }

    private final DeviceIdProvider createDeviceIdProvider() {
        return new DeviceIdProviderImpl(this.createGsfIdProvider(), this.createAndroidIdProvider());
    }

    private final CpuInfoProvider createCpuInfoProvider() {
        return new CpuInfoProviderImpl();
    }

    private final MemInfoProvider createMemoryInfoProvider() {
        Context context = FingerprinterFactory.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager activityManager = (ActivityManager)object;
        File file = Environment.getRootDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getRootDirectory()");
        StatFs internalStorageStatFs = new StatFs(file.getAbsolutePath());
        Context context2 = FingerprinterFactory.context;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        File file2 = context2.getExternalFilesDir(null);
        String string = file2 != null ? file2.getAbsolutePath() : null;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        StatFs externalStorageStatFs = new StatFs(string);
        return new MemInfoProviderImpl(activityManager, internalStorageStatFs, externalStorageStatFs);
    }

    private final OsBuildInfoProvider createOsBuildInfoProvider() {
        return new OsBuildInfoProviderImpl();
    }

    private final GsfIdProvider createGsfIdProvider() {
        Context context = FingerprinterFactory.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            Intrinsics.throwNpe();
        }
        return new GsfIdProvider(contentResolver);
    }

    private final AndroidIdProvider createAndroidIdProvider() {
        Context context = FingerprinterFactory.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            Intrinsics.throwNpe();
        }
        return new AndroidIdProvider(contentResolver);
    }

    private final SensorDataSource createSensorDataSource() {
        Context context = FingerprinterFactory.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        Object object = context.getSystemService("sensor");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        return new SensorDataSourceImpl((SensorManager)object);
    }

    private final InputDeviceDataSource createInputDevicesDataSource() {
        Context context = FingerprinterFactory.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        Object object = context.getSystemService("input");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.hardware.input.InputManager");
        }
        return new InputDevicesDataSourceImpl((InputManager)object);
    }

    private final PackageManagerDataSource createPackageManagerDataSource() {
        Context context = FingerprinterFactory.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        PackageManager packageManager = context.getPackageManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)packageManager, (String)"context.packageManager");
        return new PackageManagerDataSourceImpl(packageManager);
    }

    private final SettingsDataSource createSettingsDataSource() {
        Context context = FingerprinterFactory.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        ContentResolver contentResolver = context.getContentResolver();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentResolver, (String)"context.contentResolver");
        return new SettingsDataSourceImpl(contentResolver);
    }

    private final DevicePersonalizationDataSource createDevicePersonalizationDataSource() {
        Context context = FingerprinterFactory.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        RingtoneManager ringtoneManager = new RingtoneManager(context);
        Context context2 = FingerprinterFactory.context;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        AssetManager assetManager = context2.getAssets();
        Intrinsics.checkExpressionValueIsNotNull((Object)assetManager, (String)"context.assets");
        return new DevicePersonalizationDataSourceImpl(ringtoneManager, assetManager);
    }

    private final FingerprintSensorInfoProvider createFingerprintSensorStatusProvider() {
        Context context = FingerprinterFactory.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        FingerprintManagerCompat fingerprintManagerCompat = FingerprintManagerCompat.from((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)fingerprintManagerCompat, (String)"FingerprintManagerCompat.from(context)");
        return new FingerprintSensorInfoProviderImpl(fingerprintManagerCompat);
    }

    private final KeyGuardInfoProvider createKeyGuardInfoProvider() {
        Context context = FingerprinterFactory.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        Object object = context.getSystemService("keyguard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.KeyguardManager");
        }
        return new KeyGuardInfoProviderImpl((KeyguardManager)object);
    }

    private FingerprinterFactory() {
    }

    static {
        FingerprinterFactory fingerprinterFactory;
        INSTANCE = fingerprinterFactory = new FingerprinterFactory();
        configuration = new Configuration(1, null, 2, null);
        hasher = new MurMur3x64x128Hasher();
    }
}

