/*
 * Decompiled with CFR 0.152.
 */
package com.fingerprintjs.android.fingerprint.signal_providers.hardware;

import com.fingerprintjs.android.fingerprint.datasources.CpuInfoProvider;
import com.fingerprintjs.android.fingerprint.datasources.InputDeviceData;
import com.fingerprintjs.android.fingerprint.datasources.InputDeviceDataSource;
import com.fingerprintjs.android.fingerprint.datasources.MemInfoProvider;
import com.fingerprintjs.android.fingerprint.datasources.OsBuildInfoProvider;
import com.fingerprintjs.android.fingerprint.datasources.SensorData;
import com.fingerprintjs.android.fingerprint.datasources.SensorDataSource;
import com.fingerprintjs.android.fingerprint.signal_providers.SignalProvider;
import com.fingerprintjs.android.fingerprint.signal_providers.hardware.HardwareFingerprintRawData;
import com.fingerprintjs.android.fingerprint.tools.hashers.Hasher;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareSignalProvider;", "Lcom/fingerprintjs/android/fingerprint/signal_providers/SignalProvider;", "Lcom/fingerprintjs/android/fingerprint/signal_providers/hardware/HardwareFingerprintRawData;", "cpuInfoProvider", "Lcom/fingerprintjs/android/fingerprint/datasources/CpuInfoProvider;", "memInfoProvider", "Lcom/fingerprintjs/android/fingerprint/datasources/MemInfoProvider;", "osBuildInfoProvider", "Lcom/fingerprintjs/android/fingerprint/datasources/OsBuildInfoProvider;", "sensorsDataSource", "Lcom/fingerprintjs/android/fingerprint/datasources/SensorDataSource;", "inputDeviceDataSource", "Lcom/fingerprintjs/android/fingerprint/datasources/InputDeviceDataSource;", "hasher", "Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;", "version", "", "(Lcom/fingerprintjs/android/fingerprint/datasources/CpuInfoProvider;Lcom/fingerprintjs/android/fingerprint/datasources/MemInfoProvider;Lcom/fingerprintjs/android/fingerprint/datasources/OsBuildInfoProvider;Lcom/fingerprintjs/android/fingerprint/datasources/SensorDataSource;Lcom/fingerprintjs/android/fingerprint/datasources/InputDeviceDataSource;Lcom/fingerprintjs/android/fingerprint/tools/hashers/Hasher;I)V", "rawData", "fingerprint", "", "v1", "fingerprint_release"})
public final class HardwareSignalProvider
extends SignalProvider<HardwareFingerprintRawData> {
    private final HardwareFingerprintRawData rawData;
    private final Hasher hasher;

    @Override
    @NotNull
    public String fingerprint() {
        String string;
        switch (this.getVersion()) {
            case 1: {
                string = this.v1();
                break;
            }
            default: {
                string = this.v1();
            }
        }
        return string;
    }

    private final String v1() {
        Object it;
        StringBuilder sb = new StringBuilder();
        sb.append(this.rawData.getManufacturerName());
        sb.append(this.rawData.getModelName());
        sb.append(this.rawData.getTotalRAM());
        sb.append(this.rawData.getTotalInternalStorageSpace());
        Iterable $this$forEach$iv = this.rawData.getProcCpuInfo().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Map.Entry)element$iv;
            boolean bl = false;
            sb.append((String)it.getKey()).append((String)it.getValue());
        }
        $this$forEach$iv = this.rawData.getSensors();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SensorData)element$iv;
            boolean bl = false;
            sb.append(((SensorData)it).getSensorName()).append(((SensorData)it).getVendorName());
        }
        $this$forEach$iv = this.rawData.getInputDevices();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (InputDeviceData)element$iv;
            boolean bl = false;
            sb.append(((InputDeviceData)it).getName()).append(((InputDeviceData)it).getVendor());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return this.hasher.hash(string);
    }

    @Override
    @NotNull
    public HardwareFingerprintRawData rawData() {
        return this.rawData;
    }

    public HardwareSignalProvider(@NotNull CpuInfoProvider cpuInfoProvider, @NotNull MemInfoProvider memInfoProvider, @NotNull OsBuildInfoProvider osBuildInfoProvider, @NotNull SensorDataSource sensorsDataSource, @NotNull InputDeviceDataSource inputDeviceDataSource, @NotNull Hasher hasher, int version) {
        Intrinsics.checkNotNullParameter((Object)cpuInfoProvider, (String)"cpuInfoProvider");
        Intrinsics.checkNotNullParameter((Object)memInfoProvider, (String)"memInfoProvider");
        Intrinsics.checkNotNullParameter((Object)osBuildInfoProvider, (String)"osBuildInfoProvider");
        Intrinsics.checkNotNullParameter((Object)sensorsDataSource, (String)"sensorsDataSource");
        Intrinsics.checkNotNullParameter((Object)inputDeviceDataSource, (String)"inputDeviceDataSource");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        super(version);
        this.hasher = hasher;
        this.rawData = new HardwareFingerprintRawData(osBuildInfoProvider.manufacturerName(), osBuildInfoProvider.modelName(), memInfoProvider.totalRAM(), memInfoProvider.totalInternalStorageSpace(), cpuInfoProvider.cpuInfo(), sensorsDataSource.sensors(), inputDeviceDataSource.getInputDeviceData());
    }
}

