/*
 * Decompiled with CFR 0.152.
 */
package com.bambulabs.fdpulltorefresh.progress_bar;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.bambulabs.fdpulltorefresh.IGRefreshLayout;
import com.bambulabs.fdpulltorefresh.progress_bar.BaseProgressBar;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\rH\u0016J\u000e\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0007J\b\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u0018H\u0016J\b\u0010)\u001a\u00020\u0018H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/bambulabs/fdpulltorefresh/progress_bar/CircleProgressBar;", "Lcom/bambulabs/fdpulltorefresh/progress_bar/BaseProgressBar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backColor", "backPaint", "Landroid/graphics/Paint;", "borderWidth", "", "frontColor", "mIndeterminateSweep", "mRect", "Landroid/graphics/RectF;", "mStartAngle", "paint", "progressAnimator", "Landroid/animation/ValueAnimator;", "size", "drawProgress", "", "canvas", "Landroid/graphics/Canvas;", "onDraw", "resetAnimation", "setBorderWidth", "width", "setColors", "setParent", "parent", "Lcom/bambulabs/fdpulltorefresh/IGRefreshLayout;", "setPercent", "percent", "setSize", "px", "start", "stop", "stopAnimation", "fdpulltorefresh_release"})
public final class CircleProgressBar
extends BaseProgressBar {
    private final Paint paint;
    private int backColor;
    private int frontColor;
    private final Paint backPaint;
    private float borderWidth;
    private int size;
    private float mIndeterminateSweep;
    private float mStartAngle;
    private RectF mRect;
    private ValueAnimator progressAnimator;
    private HashMap _$_findViewCache;

    public final void setBorderWidth(int width) {
        this.paint.setStrokeWidth((float)this.dp2px(width));
        this.backPaint.setStrokeWidth((float)this.dp2px(width));
    }

    public final void setColors(int backColor, int frontColor) {
        this.paint.setColor(frontColor);
        this.backPaint.setColor(backColor);
    }

    public final void setSize(int px) {
        float f = px;
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.size = (int)(f * resources.getDisplayMetrics().density);
    }

    protected void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        RectF rectF = this.mRect;
        if (rectF != null) {
            RectF rectF2 = rectF;
            boolean bl = false;
            boolean bl2 = false;
            RectF $this$apply = rectF2;
            boolean bl3 = false;
            $this$apply.left = (this.getWidth() - this.size / 2) / 2;
            $this$apply.top = (float)this.getMParent().getDRAG_MAX_DISTANCE() / 3.0f;
            RectF rectF3 = this.mRect;
            Float f = rectF3 != null ? Float.valueOf(rectF3.left) : null;
            if (f == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.right = f.floatValue() + (float)(this.size / 2);
            RectF rectF4 = this.mRect;
            Float f2 = rectF4 != null ? Float.valueOf(rectF4.top) : null;
            if (f2 == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.bottom = f2.floatValue() + (float)(this.size / 2);
        }
        Canvas canvas2 = canvas;
        if (canvas2 != null) {
            RectF rectF5 = this.mRect;
            if (rectF5 == null) {
                Intrinsics.throwNpe();
            }
            canvas2.drawArc(rectF5, 270.0f, 360.0f, false, this.backPaint);
        }
        if (this.isLoading()) {
            Canvas canvas3 = canvas;
            if (canvas3 != null) {
                RectF rectF6 = this.mRect;
                if (rectF6 == null) {
                    Intrinsics.throwNpe();
                }
                canvas3.drawArc(rectF6, this.mStartAngle, this.mIndeterminateSweep, false, this.paint);
            }
        } else {
            Canvas canvas4 = canvas;
            if (canvas4 == null) {
                Intrinsics.throwNpe();
            }
            this.drawProgress(canvas4);
        }
    }

    private final void drawProgress(Canvas canvas) {
        RectF rectF = this.mRect;
        if (rectF == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawArc(rectF, 270.0f, this.getMPercent() * 3.6f, false, this.paint);
    }

    @Override
    public void setParent(@NotNull IGRefreshLayout parent) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)parent), (String)"parent");
        this.setMParent(parent);
    }

    @Override
    public void setPercent(float percent) {
        this.setMPercent(percent >= 100.0f ? 100.0f : percent);
        this.invalidate();
    }

    @Override
    public void start() {
        this.setLoading(true);
        this.resetAnimation();
    }

    @Override
    public void stop() {
        this.stopAnimation();
    }

    private final void resetAnimation() {
        block8: {
            if (this.progressAnimator != null) {
                ValueAnimator valueAnimator = this.progressAnimator;
                if (valueAnimator == null) {
                    Intrinsics.throwNpe();
                }
                if (valueAnimator.isRunning()) {
                    ValueAnimator valueAnimator2 = this.progressAnimator;
                    if (valueAnimator2 != null) {
                        valueAnimator2.cancel();
                    }
                }
            }
            ValueAnimator valueAnimator = this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
            if (valueAnimator != null) {
                valueAnimator.setDuration(500L);
            }
            ValueAnimator valueAnimator3 = this.progressAnimator;
            if (valueAnimator3 != null) {
                valueAnimator3.setInterpolator((TimeInterpolator)new LinearInterpolator());
            }
            ValueAnimator valueAnimator4 = this.progressAnimator;
            if (valueAnimator4 != null) {
                valueAnimator4.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                    final /* synthetic */ CircleProgressBar this$0;

                    public final void onAnimationUpdate(ValueAnimator it) {
                        ValueAnimator valueAnimator = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                        Object object = valueAnimator.getAnimatedValue();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                        }
                        CircleProgressBar.access$setMStartAngle$p(this.this$0, ((Float)object).floatValue());
                        this.this$0.invalidate();
                    }
                    {
                        this.this$0 = circleProgressBar;
                    }
                });
            }
            ValueAnimator valueAnimator5 = this.progressAnimator;
            if (valueAnimator5 != null) {
                valueAnimator5.start();
            }
            ValueAnimator valueAnimator6 = this.progressAnimator;
            if (valueAnimator6 == null) break block8;
            valueAnimator6.addListener(new Animator.AnimatorListener(this){
                final /* synthetic */ CircleProgressBar this$0;

                public void onAnimationRepeat(@Nullable Animator p0) {
                }

                public void onAnimationEnd(@Nullable Animator p0) {
                    CircleProgressBar.access$resetAnimation(this.this$0);
                }

                public void onAnimationCancel(@Nullable Animator p0) {
                }

                public void onAnimationStart(@Nullable Animator p0) {
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    private final void stopAnimation() {
        this.setLoading(false);
        if (this.progressAnimator != null) {
            ValueAnimator valueAnimator = this.progressAnimator;
            if (valueAnimator != null) {
                valueAnimator.cancel();
            }
            ValueAnimator valueAnimator2 = this.progressAnimator;
            if (valueAnimator2 != null) {
                valueAnimator2.removeAllListeners();
            }
            this.progressAnimator = null;
        }
    }

    @JvmOverloads
    public CircleProgressBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.paint = new Paint(1);
        this.backColor = -3355444;
        this.frontColor = -7829368;
        this.backPaint = new Paint(1);
        this.borderWidth = this.dp2px(4);
        this.size = this.dp2px(80);
        this.paint.setColor(this.frontColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.borderWidth);
        this.backPaint.setColor(this.backColor);
        this.backPaint.setStyle(Paint.Style.STROKE);
        this.backPaint.setStrokeWidth(this.borderWidth);
        this.mRect = new RectF();
        this.mIndeterminateSweep = 85.0f;
    }

    public /* synthetic */ CircleProgressBar(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CircleProgressBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CircleProgressBar(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ float access$getMStartAngle$p(CircleProgressBar $this) {
        return $this.mStartAngle;
    }

    public static final /* synthetic */ void access$setMStartAngle$p(CircleProgressBar $this, float f) {
        $this.mStartAngle = f;
    }

    public static final /* synthetic */ void access$resetAnimation(CircleProgressBar $this) {
        $this.resetAnimation();
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

