/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.parse;

import com.github.fge.uritemplate.CharMatchers;
import com.github.fge.uritemplate.URITemplateParseException;
import com.github.fge.uritemplate.expression.TemplateLiteral;
import com.github.fge.uritemplate.expression.URITemplateExpression;
import com.github.fge.uritemplate.parse.TemplateParser;
import java.nio.CharBuffer;

final class LiteralParser
implements TemplateParser {
    LiteralParser() {
    }

    @Override
    public URITemplateExpression parse(CharBuffer buffer) throws URITemplateParseException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining() && CharMatchers.LITERALS.matches(c = buffer.charAt(0))) {
            sb.append(buffer.get());
            if (!CharMatchers.PERCENT.matches(c)) continue;
            LiteralParser.parsePercentEncoded(buffer, sb);
        }
        return new TemplateLiteral(sb.toString());
    }

    private static void parsePercentEncoded(CharBuffer buffer, StringBuilder sb) throws URITemplateParseException {
        if (buffer.remaining() < 2) {
            throw new URITemplateParseException("not enough remaining characters for a percent-encoded sequence", buffer, true);
        }
        char first = buffer.get();
        if (!CharMatchers.HEXDIGIT.matches(first)) {
            throw new URITemplateParseException("illegal character in percent-encoded sequence", buffer, true);
        }
        char second = buffer.get();
        if (!CharMatchers.HEXDIGIT.matches(second)) {
            throw new URITemplateParseException("illegal character in percent-encoded sequence", buffer, true);
        }
        sb.append(first).append(second);
    }
}

