/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.expression;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.expression.URITemplateExpression;
import com.github.fge.uritemplate.vars.VariableSpec;
import com.github.fge.uritemplate.vars.VariableValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class TemplateExpression
implements URITemplateExpression {
    private final ExpressionType expressionType;
    private final List<VariableSpec> variableSpecs;

    public TemplateExpression(ExpressionType expressionType, List<VariableSpec> variableSpecs) {
        this.expressionType = expressionType;
        this.variableSpecs = ImmutableList.copyOf(variableSpecs);
    }

    @Override
    public String expand(Map<String, VariableValue> vars) throws URITemplateException {
        ArrayList list = Lists.newArrayList();
        for (VariableSpec varspec : this.variableSpecs) {
            String rendered;
            String varname = varspec.getName();
            VariableValue value = vars.get(varname);
            if (value == null || (rendered = varspec.render(this.expressionType, value)) == null) continue;
            list.add(rendered);
        }
        if (list.isEmpty()) {
            return "";
        }
        Joiner joiner = Joiner.on((char)this.expressionType.getSeparator());
        String joined = joiner.join((Iterable)list);
        return this.expressionType.getPrefix() + joined;
    }

    public int hashCode() {
        return 31 * this.expressionType.hashCode() + this.variableSpecs.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateExpression other = (TemplateExpression)obj;
        return this.expressionType == other.expressionType && this.variableSpecs.equals(other.variableSpecs);
    }
}

