/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.bundle;

import com.github.fge.Thawed;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.provider.MessageSourceProvider;
import com.github.fge.msgsimple.provider.StaticMessageSourceProvider;
import com.github.fge.msgsimple.serviceloader.MessageBundles;
import com.github.fge.msgsimple.serviceloader.MsgSimpleMessageBundle;
import com.github.fge.msgsimple.source.MessageSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class MessageBundleBuilder
implements Thawed<MessageBundle> {
    private static final MessageBundle BUNDLE = MessageBundles.forClass(MsgSimpleMessageBundle.class);
    final List<MessageSourceProvider> providers = new ArrayList<MessageSourceProvider>();

    MessageBundleBuilder() {
    }

    MessageBundleBuilder(MessageBundle bundle) {
        this.providers.addAll(bundle.providers);
    }

    public MessageBundleBuilder appendProvider(MessageSourceProvider provider) {
        if (provider == null) {
            throw new NullPointerException(BUNDLE.getMessage("cfg.nullProvider"));
        }
        this.providers.add(provider);
        return this;
    }

    public MessageBundleBuilder prependProvider(MessageSourceProvider provider) {
        if (provider == null) {
            throw new NullPointerException(BUNDLE.getMessage("cfg.nullProvider"));
        }
        this.providers.add(0, provider);
        return this;
    }

    public MessageBundleBuilder appendSource(MessageSource source) {
        MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(source);
        this.providers.add(provider);
        return this;
    }

    public MessageBundleBuilder prependSource(MessageSource source) {
        MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(source);
        this.providers.add(0, provider);
        return this;
    }

    public MessageBundleBuilder appendSource(Locale locale, MessageSource source) {
        MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(locale, source);
        this.providers.add(provider);
        return this;
    }

    public MessageBundleBuilder prependSource(Locale locale, MessageSource source) {
        MessageSourceProvider provider = StaticMessageSourceProvider.withSingleSource(locale, source);
        this.providers.add(0, provider);
        return this;
    }

    public MessageBundle freeze() {
        return new MessageBundle(this);
    }
}

