/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.bundle;

import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.provider.LoadingMessageSourceProvider;
import com.github.fge.msgsimple.provider.MessageSourceLoader;
import com.github.fge.msgsimple.provider.MessageSourceProvider;
import com.github.fge.msgsimple.source.MessageSource;
import com.github.fge.msgsimple.source.PropertiesMessageSource;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;

public final class PropertiesBundle {
    private static final Pattern SUFFIX = Pattern.compile("\\.properties$");

    private PropertiesBundle() {
    }

    public static MessageBundle forPath(String resourcePath) {
        if (resourcePath == null) {
            throw new NullPointerException("resource path is null");
        }
        String s = resourcePath.startsWith("/") ? resourcePath : '/' + resourcePath;
        final String realPath = SUFFIX.matcher(s).replaceFirst("");
        MessageSourceLoader loader = new MessageSourceLoader(){

            @Override
            public MessageSource load(Locale locale) throws IOException {
                StringBuilder sb = new StringBuilder(realPath);
                if (!locale.equals(Locale.ROOT)) {
                    sb.append('_').append(locale.toString());
                }
                sb.append(".properties");
                return PropertiesMessageSource.fromResource(sb.toString());
            }
        };
        MessageSourceProvider provider = LoadingMessageSourceProvider.newBuilder().setLoader(loader).build();
        return MessageBundle.newBuilder().appendProvider(provider).freeze();
    }
}

