/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.EnumSet;

public final class DraftV4TypeValidator
extends AbstractKeywordValidator {
    private final EnumSet<NodeType> types = EnumSet.noneOf(NodeType.class);

    public DraftV4TypeValidator(JsonNode digest) {
        super("type");
        for (JsonNode node : digest.get(this.keyword)) {
            this.types.add(NodeType.fromName((String)node.textValue()));
        }
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        NodeType type = NodeType.getNodeType((JsonNode)data.getInstance().getNode());
        if (!this.types.contains(type)) {
            report.error(this.newMsg(data, bundle, "err.common.typeNoMatch").putArgument("found", (Object)type).putArgument("expected", DraftV4TypeValidator.toArrayNode(this.types)));
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.types;
    }
}

