/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.helpers.NumericValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.math.BigDecimal;

public final class MaximumValidator
extends NumericValidator {
    private final boolean exclusive;

    public MaximumValidator(JsonNode digest) {
        super("maximum", digest);
        this.exclusive = digest.path("exclusive").booleanValue();
    }

    @Override
    protected void validateLong(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        long longValue;
        JsonNode instance = data.getInstance().getNode();
        long instanceValue = instance.longValue();
        if (instanceValue < (longValue = this.number.longValue())) {
            return;
        }
        if (instanceValue > longValue) {
            report.error(this.newMsg(data, bundle, "err.common.maximum.tooLarge").putArgument(this.keyword, this.number).putArgument("found", instance));
            return;
        }
        if (!this.exclusive) {
            return;
        }
        report.error(this.newMsg(data, bundle, "err.common.maximum.notExclusive").putArgument(this.keyword, this.number).put("exclusiveMaximum", (JsonNode)BooleanNode.TRUE));
    }

    @Override
    protected void validateDecimal(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        BigDecimal decimalValue;
        JsonNode instance = data.getInstance().getNode();
        BigDecimal instanceValue = instance.decimalValue();
        int cmp = instanceValue.compareTo(decimalValue = this.number.decimalValue());
        if (cmp < 0) {
            return;
        }
        if (cmp > 0) {
            report.error(this.newMsg(data, bundle, "err.common.maximum.tooLarge").putArgument(this.keyword, this.number).putArgument("found", instance));
            return;
        }
        if (!this.exclusive) {
            return;
        }
        report.error(this.newMsg(data, bundle, "err.common.maximum.notExclusive").putArgument(this.keyword, this.number).put("exclusiveMaximum", (JsonNode)BooleanNode.TRUE));
    }
}

