/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.msgsimple.bundle.MessageBundle;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public final class EmailAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute INSTANCE = new EmailAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private EmailAttribute() {
        super("email", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String value = data.getInstance().getNode().textValue();
        try {
            new InternetAddress(value, true);
        }
        catch (AddressException ignored) {
            report.error(this.newMsg(data, bundle, "err.format.invalidEmail").putArgument("value", (Object)value));
        }
    }
}

