/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.messages;

import com.github.fge.jsonschema.exceptions.unchecked.ProcessingError;
import com.github.fge.jsonschema.report.ProcessingMessage;
import java.util.ResourceBundle;

public final class MessageBundle {
    private final ResourceBundle bundle;
    private final ErrorProvider errorProvider;

    public MessageBundle(String name, ErrorProvider errorProvider) {
        this.bundle = ResourceBundle.getBundle(name);
        this.errorProvider = errorProvider;
    }

    public String getString(String key) {
        return this.bundle.getString(key);
    }

    public ProcessingMessage message(String key) {
        return new ProcessingMessage().message(this.bundle.getString(key));
    }

    public void checkNotNull(Object obj, String key) {
        if (obj == null) {
            throw this.errorProvider.doError(this.bundle.getString(key));
        }
    }

    static interface ErrorProvider {
        public ProcessingError doError(String var1);
    }
}

